% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weakly.stationaryV1.R
\name{weakly.stationary}
\alias{weakly.stationary}
\title{Testing for Weak Stationarity in a Time Series}
\usage{
weakly.stationary(tseries, signific_gen = 0.05, signific_pp.df = 0.05,
  MK = FALSE, BP = TRUE, PSR = TRUE, weak.dep = FALSE,
  mode = "neutral")
}
\arguments{
\item{tseries}{a 1-D or 2-D array. In the latter case, the time series to be evaluated
must be placed in the 2nd dimension (columns). If that's not your case, transpose it.}

\item{signific_gen}{significance level for all tests except Phillips-Perron and Augmented Dickey-Fuller.}

\item{signific_pp.df}{significance level for the Phillips-Perron and Augmented Dickey-Fuller tests.}

\item{MK}{if TRUE, the Mann-Kendall test for constant mean is executed, instead of a faster basic test. Default is FALSE.}

\item{BP}{if TRUE, the Breusch-Pagan test for constant (residual) variance is executed
on the residuals of an auxiliary linear model that includes a time variable, instead of
the McLeod-Li test. The default is TRUE.}

\item{PSR}{if TRUE, the Priestley-Subba Rao test for nonstationarity across time is
executed. The default is TRUE.}

\item{weak.dep}{if TRUE, then the Phillips-Perron, Augmented Dickey-Fuller, and
KPSS tests for weak stationarity (assuming an AR(p)) are performed.}

\item{mode}{one of "neutral", "strict", "loose". Case insenstive. The default is "neutral".}
}
\value{
if a 1-D array is supplied, then a Boolean is returned indicating whether
the time series supplied is weakly stationary (TRUE) or not (FALSE).
If a 2-D array is supplied, then a vector of Booleans is returned indicating whether
each individual time series supplied is weakly stationary (TRUE) or not (FALSE).
}
\description{
Performs a series of statistical tests aimed at detecting non-stationarity.
}
\details{
This function offers a great deal of customization: diverse significance levels,
multiple tests specialized in certain aspects of (weak) stationarity, as well as
handy predefined sets of parameters providing a more or less strict diagnostic:
"neutral", "strict" and "loose" modes. By including this possibility, the technical burden
on the user is made lighter. Mode "strict" includes two tests for constant mean
(basic & Mann-Kendall), two tests for constant variance (McLeod-Li & Breusch-Pagan tests),
the Priestley-Subba Rao (PSR) test for nonstationarity across time, and three tests for
weak dependence (Phillips-Perron, Augmented Dickey-Fuller, and KPSS tests), which test
weak stationarity if and only if the underlying data generating process is assumed to be an AR(p).
Mode "loose" just performs the basic test for constant mean (a linear model that includes a trend
whose statistical significance is determined using robust regression if the Durbin Watson
test detects serial correlation in the residuals),
and the Breusch-Pagan test (on the previous auxiliary linear model's residuals) for constant
variance. Mode "neutral" (the default) provides all the default parameter options.
Significance levels also differ across modes.
This function differentiates two significance levels: general (\code{signific_gen})
and specific to the Phillips-Perron and Augmented Dickey-Fuller tests (\code{signific_pp.df}).
In mode "strict", \code{signific_gen} is 0.1, and \code{signific_pp.df} is 0.01.
In mode "loose", \code{signific_gen} is 0.01, and \code{signific_pp.df} is irrelevant.
In mode "neutral", both significance levels are set to 0.05.
}
\examples{
x1 <- rnorm(1e2)
weakly.stationary(tseries = x1)
weakly.stationary(tseries = x1, signific_gen = 0.025)
weakly.stationary(tseries = x1, signific_pp.df = 0.1)
weakly.stationary(tseries = x1, PSR = FALSE)
weakly.stationary(tseries = x1, weak.dep = TRUE)
weakly.stationary(tseries = x1, mode = "strict")
weakly.stationary(tseries = x1, mode = "loose")

require(stats)
set.seed(123)
x2 <- arima.sim(n = 1e2, list(ar = 0.4))
weakly.stationary(tseries = x2)
weakly.stationary(tseries = x2, signific_gen = 0.01)
weakly.stationary(tseries = x2, PSR = FALSE)
weakly.stationary(tseries = x2, weak.dep = TRUE)
weakly.stationary(tseries = x2, mode = "strict")
weakly.stationary(tseries = x2, mode = "loose")

}
\author{
Albert Dorador
}
