% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r-batch-eda-utilities.R
\name{outlierPlot}
\alias{outlierPlot}
\title{Outlier detection plot}
\usage{
outlierPlot(data, method = "iqr", columnName, cutoffValue = 0.05,
  priColor = "blue", optionalPlots = 0)
}
\arguments{
\item{data}{the dataframe that needs to be loaded}

\item{method}{the method on which outliers are to be identified}

\item{columnName}{the name of column for which the outliers are identified}

\item{cutoffValue}{the cut off value to define the threshold for outliers}

\item{priColor}{the primary color for the plots}

\item{optionalPlots}{A Flag for optional plots}
}
\value{
Outliers plot object
}
\description{
Outlier detection plot
}
\details{
Outlier are to be identified on the selected column from the dataframe
}
\examples{
\dontrun{
outlierPlot(data = iris, columnName = "Sepal.Length")
}
}
\seealso{
Other Package EDA Utilites functions: \code{\link{CheckColumnType}},
  \code{\link{bivarPlots}},
  \code{\link{correlationMatPlot}},
  \code{\link{getDatatype}}, \code{\link{ignoreCols}},
  \code{\link{multiVarOutlierPlot}},
  \code{\link{univarCatDistPlots}}
}
\concept{Package EDA Utilites functions}
