% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSI.R
\name{SSI}
\alias{SSI}
\title{Simultaneous Selection Indices for Yield and Stability}
\usage{
SSI(y, sp, gen, method = c("farshadfar", "rao"), a = 1)
}
\arguments{
\item{y}{A numeric vector of the mean yield/performance of genotypes.}

\item{sp}{A numeric vector of the stability parameter/index of the genotypes.}

\item{gen}{A character vector of the names of the genotypes.}

\item{method}{The method for the computation of simultaneous selection index.
Either \code{"farshadfar"} or \code{"rao"} (See \strong{Details}).}

\item{a}{The ratio of the weights given to the stability components for
computation of SSI when \code{method = "rao"} (See \strong{Details}).}
}
\value{
A data frame with the following columns:  \item{SP}{The stability
  parameter values.} \item{SSI}{The computed values of simultaneous selection
  index for yield and stability.} \item{rSP}{The ranks of the stability
  parameter.} \item{rY}{The ranks of the mean yield of genotypes.}
  \item{means}{The mean yield of the genotypes.}

  The names of the genotypes are indicated as the row names of the data
  frame.
}
\description{
\code{SSI} computes the Simultaneous Selection Index for Yield and Stability
(SSI) according to the methods specified in the argument \code{method}.
\loadmathjax
}
\details{
The SSI according to \insertCite{rao_use_2005;textual}{ammistability}
(\mjseqn{I_{i}}) is computed as follows:

\mjsdeqn{I_{i} = \frac{\overline{Y}_{i}}{\overline{Y}_{..}} + \alpha
\frac{\frac{1}{SP_{i}}}{\frac{1}{T}\sum_{i=1}^{T}\frac{1}{SP_{i}}}}

Where \mjseqn{SP_{i}} is the stability measure of the \mjseqn{i}th genotype
under AMMI procedure; \mjseqn{\overline{Y}_{i}} is mean performance of
\mjseqn{i}th genotype; \mjseqn{\overline{Y}_{..}} is the overall mean;
\mjseqn{T} is the number of genotypes under test and \mjseqn{\alpha} is the
ratio of the weights given to the stability components (\mjseqn{w_{2}}) and
yield (\mjseqn{w_{1}}) with a restriction that \mjseqn{w_{1} + w_{2} = 1}.
The weights can be specified as required.

\tabular{rrr}{ \strong{\mjseqn{\alpha}} \tab \strong{\mjseqn{w_{1}}} \tab
\strong{\mjseqn{w_{2}}}\cr 1.00 \tab 0.5 \tab 0.5\cr 0.67 \tab 0.6 \tab
0.4\cr 0.43 \tab 0.7 \tab 0.3\cr 0.25 \tab 0.8 \tab 0.2 }

The SSI proposed by
\insertCite{farshadfar_incorporation_2008;textual}{ammistability} is called
the Genotype stability index (\mjseqn{GSI}) or Yield stability index
(\mjseqn{YSI}) \insertCite{farshadfar_ammi_2011}{ammistability} and is
computed by summation of the ranks of the stability index/parameter and the
ranks of the mean yields.

\mjsdeqn{GSI = YSI = R_{SP} + R_{Y}}

Where, \mjseqn{R_{SP}} is the stability parameter/index rank of the genotype
and \mjseqn{R_{Y}} is the mean yield rank of the genotype.
}
\examples{
library(agricolae)
data(plrv)
model <- with(plrv, AMMI(Locality, Genotype, Rep, Yield, console=FALSE))

yield <- aggregate(model$means$Yield, by= list(model$means$GEN),
               FUN=mean, na.rm=TRUE)[,2]
stab <- DZ.AMMI(model)$DZ
genotypes <- rownames(DZ.AMMI(model))

# With default ssi.method (farshadfar)
SSI(y = yield, sp = stab, gen = genotypes)

# With  ssi.method = "rao"
SSI(y = yield, sp = stab, gen = genotypes, method = "rao")

# Changing the ratio of weights for Rao's SSI
SSI(y = yield, sp = stab, gen = genotypes, method = "rao", a = 0.43)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[ammistability]{AMGE.AMMI}},
  \code{\link[ammistability]{ASI.AMMI}},
  \code{\link[ammistability]{ASTAB.AMMI}},
  \code{\link[ammistability]{AVAMGE.AMMI}},
  \code{\link[ammistability]{DA.AMMI}}, \code{\link[ammistability]{DZ.AMMI}},
  \code{\link[ammistability]{EV.AMMI}}, \code{\link[ammistability]{FA.AMMI}},
  \code{\link[ammistability]{MASV.AMMI}},
  \code{\link[ammistability]{SIPC.AMMI}},
  \code{\link[ammistability]{ZA.AMMI}}
}
