% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{using_config}
\alias{using_config}
\title{Detect whether a configuration is currently active}
\usage{
using_config(config)
}
\arguments{
\item{config}{Configuration name}
}
\value{
A logical value
}
\description{
Environment-specific configuration values can be used to alter code's
behavior in different environments. The
\href{https://CRAN.R-project.org/package=config}{config} package uses the
\code{R_CONFIG_ACTIVE} environment variable to specify the active environment.
If \code{R_CONFIG_ACTIVE} is not set, the \code{"default"} configuration is used.
}
\examples{
# See whether the default configuration is being used
using_config("default")

# See whether the "production" configuration is being used
using_config("production")
}
