% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/raSab_frn_fc.R
\name{raSab_frn_fc}
\alias{raSab_frn_fc}
\title{Simulate a and Sab from full conditional distributions under frn likelihood}
\usage{
raSab_frn_fc(Z, Y, YL, a, b, Sab, odmax, odobs, SS =
round(sqrt(nrow(Z))))
}
\arguments{
\item{Z}{a square matrix, the current value of Z}

\item{Y}{square matrix of ranked nomination data}

\item{YL}{list of ranked individuals, from least to most preferred in each
row}

\item{a}{current value of row effects}

\item{b}{current value of column effects}

\item{Sab}{current value of Cov(a,b)}

\item{odmax}{a scalar or vector giving the maximum number of nominations for
each individual}

\item{odobs}{observed outdegree}

\item{SS}{number of iterations}
}
\value{
\item{Z}{new value of Z} \item{Sab}{new value of Sab} \item{a}{new
value of a}
}
\description{
Simulate a and Sab from full conditional distributions under frn likelihood
}
\author{
Peter Hoff
}

