% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logger.R
\name{Logger}
\alias{Logger}
\title{Logger}
\value{
An object of class \code{Logger} that can be used to log
events in an application.
}
\description{
Log events to \code{ambiorix.log}.
}
\details{
The logger prepends every \code{write} with the current timestamp obtained with \code{\link[=Sys.time]{Sys.time()}}.
Every \code{write} is a single line in the log.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{run}}{Whether to actually log events to the file.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Logger$new()}}
\item \href{#method-write}{\code{Logger$write()}}
\item \href{#method-log}{\code{Logger$log()}}
\item \href{#method-print}{\code{Logger$print()}}
\item \href{#method-clone}{\code{Logger$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Logger$new(log = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{log}}{Whether to log events, if \code{FALSE} the \code{write} method does not have any effect.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Initialise
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-write"></a>}}
\if{latex}{\out{\hypertarget{method-write}{}}}
\subsection{Method \code{write()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Logger$write(label, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{label}}{Label of event to log.}

\item{\code{...}}{Any other text to write alongside.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Write events to log file - deprecated
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-log"></a>}}
\if{latex}{\out{\hypertarget{method-log}{}}}
\subsection{Method \code{log()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Logger$log(label, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{label}}{Label of event to log.}

\item{\code{...}}{Any other text to write alongside.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Write events to log file
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Logger$print()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Print the logger state
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Logger$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
