% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores.tables.tweak.R
\name{scores.tables.tweak}
\alias{scores.tables.tweak}
\title{Tweak summary table}
\usage{
scores.tables.tweak(myVariables,
  myCaption = "Globally averaged statistical metrics",
  inputDir = getwd(), outputDir = FALSE)
}
\arguments{
\item{myVariables}{An R object with variable names of variables that should be included in table, e.g. c('GPP', 'RECO', 'NEE')}

\item{myCaption}{A string that is used as table caption, e.g. 'Globally averaged statistical metrics'.}

\item{inputDir}{A string that gives the input directory, e.g. '/home/project/study'.}

\item{outputDir}{A string that gives the output directory, e.g. '/home/project/study'. The output will only be written if the user specifies an output directory.}
}
\value{
One table in LaTeX format that shows a subset of statistical metrics
}
\description{
This function allows the user to tweak the summary table computed
by \link{scores.tables}. Contrary to \link{scores.tables}, this function can be used
to create a single summary table that includes the most important metrics only.
The user can specify what variables to include and in what order they should appear.
}
\examples{
library(amber)
library(classInt)
library(doParallel)
library(foreach)
library(Hmisc)
library(latex2exp)
library(ncdf4)
library(parallel)
library(raster)
library(rgdal)
library(rgeos)
library(scico)
library(sp)
library(stats)
library(utils)
library(viridis)
library(xtable)

myInputDir <- paste(system.file('extdata', package = 'amber'), 'scores', sep = '/')
myVariables <- c('GPP', 'LAI', 'ALBS')
scores.tables.tweak(myVariables = myVariables, inputDir = myInputDir)
}
