% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sequence.R
\name{maskSeqGaps}
\alias{maskSeqGaps}
\title{Masks gap characters in DNA sequences}
\usage{
maskSeqGaps(seq, outer_only = FALSE)
}
\arguments{
\item{seq}{a character vector of DNA sequence strings.}

\item{outer_only}{if \code{TRUE} replace only contiguous leading and trailing gaps;
if \code{FALSE} replace all gap characters.}
}
\value{
A modified \code{seq} vector with \code{"N"} in place of \code{c("-", ".")} 
          characters.
}
\description{
\code{maskSeqGaps} substitutes gap characters, \code{c("-", ".")}, with \code{"N"} 
in a vector of DNA sequences.
}
\examples{
maskSeqGaps(c("ATG-C", "CC..C"))
maskSeqGaps("--ATG-C-")
maskSeqGaps("--ATG-C-", outer_only=TRUE)

}
\seealso{
Other sequence manipulation functions: \code{\link{collapseDuplicates}},
  \code{\link{maskSeqEnds}}
}

