% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AminoAcids.R
\name{gravy}
\alias{gravy}
\title{Calculates the hydrophobicity of amino acid sequences}
\usage{
gravy(seq, hydropathy = NULL)
}
\arguments{
\item{seq}{vector of strings containing amino acid sequences.}

\item{hydropathy}{named numerical vector defining hydropathy index values for 
each amino acid, where names are single-letter amino acid 
character codes. If \code{NULL}, then the Kyte & Doolittle
scale is used.}
}
\value{
A vector of GRAVY scores for the sequence(s).
}
\description{
\code{gravy} calculates the Grand Average of Hydrophobicity (GRAVY) index 
of amino acid sequences using the method of Kyte & Doolittle. Non-informative
positions are excluded, where non-informative is defined as any character in 
\code{c("X", "-", ".", "*")}.
}
\examples{
# Default scale
seq <- c("CARDRSTPWRRGIASTTVRTSW", "XXTQMYVRT")
gravy(seq)

# Use the Kidera et al, 1985 scores from the seqinr package
library(seqinr)
data(aaindex)
x <- aaindex[["KIDA850101"]]$I
# Rename the score vector to use single-letter codes
names(x) <- translateStrings(names(x), ABBREV_AA)
# Calculate hydrophobicity
gravy(seq, hydropathy=x)

}
\references{
\enumerate{
  \item  Kyte J, Doolittle RF. A simple method for displaying the hydropathic character 
           of a protein. J Mol Biol. 157, 105-32 (1982).
}
}
\seealso{
For additional hydrophobicity indices see \code{\link[seqinr]{aaindex}}.
}

