% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_imputation.R
\name{data_imputation}
\alias{data_imputation}
\title{Data imputation for longitudinal data}
\usage{
data_imputation(traj, id_field = FALSE, method = 2,
replace_with = 1, fill_zeros = FALSE, verbose=TRUE)
}
\arguments{
\item{traj}{[\code{matrix (numeric)}]: longitudinal data. Each
row represents an individual trajectory (of observations). The
columns show the observations at consecutive time points.}

\item{id_field}{[numeric or character] Whether the first column
of the \code{traj} is a unique (\code{id}) field. Default:
\code{FALSE}. If \code{TRUE} the function recognises the second
column as the first time step.}

\item{method}{[an integer] indicating a method for calculating
the missing values. Options are: \code{'1'}: \code{arithmetic}
 method, and \code{'2'}: \code{regression} method. The default
 is \code{'1'}: \code{arithmetic} method}

\item{replace_with}{[an integer from 1 to 6] indicating the technique,
based on a specified \code{method}, for calculating the missing entries.
\code{'1'}: \code{arithmetic} method, \code{replace_with} options are:
\code{'1'}: Mean value of the corresponding column;
\code{'2'}: Minimum value of corresponding column; \code{'3'}:
Maximum value of corresponding column;
\code{'4'}: Mean value of corresponding row; \code{'5'}:
Minimum value of corresponding row,
or \code{'6'}: Maximum value of corresponding row. For \code{'2'}:
regression method:
the available option for the \code{replace_with} is: \code{'1'}:
\code{linear}.
The regression method fits a linear regression line to a trajectory
with missing entry(s)
and estimates the missing data values from the regression line.
Note: only the missing data points derive their new values from the
regression line
while the rest of the data points retain their original values. The
function terminates if there are
trajectories with only one observation. The default is \code{'1'}: Mean
value of the corresponding column}

\item{fill_zeros}{[TRUE or FALSE] whether to consider zeros \code{0}
as missing values when \code{2: regression} method is used. The default
is \code{FALSE}.}

\item{verbose}{to suppress printing output messages (to the console).
Default: \code{TRUE}.}
}
\value{
A data.frame with missing values (\code{NA}, \code{Inf},
\code{null}) imputed according to the a specified technique.
}
\description{
This function fills any missing entries (\code{NA},
\code{Inf}, \code{null}) in a matrix or dataframe, according to
a specified method. By default, \code{'0'} is considered a value.
}
\details{
Given a matrix or data.frame with some missing values
indicated by (\code{NA}, \code{Inf}, \code{null}), this function
impute the missing value by using either an estimation from the
corresponding rows or columns, or to use a regression method to
estimate the missing values.
}
\examples{

# Using the example 'traj' datasets

imp_data <- data_imputation(traj, id_field = TRUE, method = 2,
replace_with = 1,
fill_zeros = FALSE, verbose=FALSE)

}
