% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_archives.R
\name{download_radiation}
\alias{download_radiation}
\title{Download Ultraviolet Radiation Archives}
\usage{
download_radiation(type, year, progress = interactive())
}
\arguments{
\item{type}{type of data to download.
\itemize{
 \item{"UVA"}{ - long wave ultraviolet A}
 \item{"UVB"}{ - short wave ultraviolet B}
}}

\item{year}{a numeric vector containing the years for which to download data
(the earliest possible value is 2000)}

\item{progress}{whether to display a progress bar (TRUE or FALSE).
By default it will only display in an interactive session.}
}
\value{
A data.frame with pollution data. The
hours correspond to the
\emph{Etc/GMT+6} timezone, with no daylight saving time
}
\description{
Download data on UVA and UVB from the pollution archives available at
\href{http://www.aire.cdmx.gob.mx/default.php?opc=\%27aKBhnmI=\%27&opcion=bA==}{Radiación Solar (UVA)}
and
\href{http://www.aire.cdmx.gob.mx/default.php?opc=\%27aKBhnmI=\%27&opcion=bQ==}{Radiación Solar (UVB)}
}
\examples{
\dontrun{
head(download_radiation("UVA", 2017))
}
}
