% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install_and_config.R
\name{update_aifeducation}
\alias{update_aifeducation}
\title{Updates an existing installation of 'aifeducation' on a machine}
\usage{
update_aifeducation(
  update_aifeducation_studio = TRUE,
  env_type = "auto",
  cuda_version = "12.4",
  envname = "aifeducation"
)
}
\arguments{
\item{update_aifeducation_studio}{\code{bool} If \code{TRUE} all necessary R packages are installed for using AI for Education
Studio.}

\item{env_type}{\code{string} If set to \code{"venv"}  virtual environment is requested. If set to
\code{"conda"} a 'conda' environment is requested. If set to \code{"auto"} the function tries to
use a virtual environment with the given name. If this environment does not exist
it tries to activate a conda environment with the given name. If this fails
the default virtual environment is used.'}

\item{cuda_version}{\code{string} determining the requested version of cuda.}

\item{envname}{\code{string} Name of the environment where the packages should be installed.}
}
\value{
Function does nothing return. It installs python, optional R packages, and necessary 'python' packages on a
machine.
}
\description{
Function for updating 'aifeducation' on a machine.

The function tries to find an existing environment on the machine, removes the
environment and installs the environment with the new python modules.

In the case \code{env_type = "auto"} the function tries to update an existing virtual environment.
If no virtual environment exits it tries to update a conda environment.
}
\note{
On MAC OS torch will be installed without support for cuda.
}
\seealso{
Other Installation and Configuration: 
\code{\link{check_aif_py_modules}()},
\code{\link{get_recommended_py_versions}()},
\code{\link{install_aifeducation}()},
\code{\link{install_aifeducation_studio}()},
\code{\link{install_py_modules}()},
\code{\link{prepare_session}()},
\code{\link{set_transformers_logger}()}
}
\concept{Installation and Configuration}
