% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_fct.R
\name{split_labeled_unlabeled}
\alias{split_labeled_unlabeled}
\title{Split data into labeled and unlabeled data}
\usage{
split_labeled_unlabeled(embedding, target)
}
\arguments{
\item{embedding}{Object of class \link{EmbeddedText}.}

\item{target}{Named \code{factor} containing all cases with labels and missing
labels.}
}
\value{
Returns a \code{list} with the following components
\itemize{
\item{\code{embeddings_labeled: }}{Object of class \link{EmbeddedText} containing
only the cases which have labels.}

\item{\code{embeddings_unlabeled: }}{Object of class \link{EmbeddedText} containing
only the cases which have no labels.}

\item{\code{targets_labeled: }}{Named \code{factor} containing the labels of
relevant cases.}
}
}
\description{
This functions splits data into labeled and unlabeled data.
}
\seealso{
Other Auxiliary Functions: 
\code{\link{array_to_matrix}()},
\code{\link{check_embedding_models}()},
\code{\link{create_iota2_mean_object}()},
\code{\link{create_synthetic_units}()},
\code{\link{generate_id}()},
\code{\link{get_coder_metrics}()},
\code{\link{get_folds}()},
\code{\link{get_n_chunks}()},
\code{\link{get_stratified_train_test_split}()},
\code{\link{get_synthetic_cases}()},
\code{\link{get_train_test_split}()},
\code{\link{matrix_to_array_c}()},
\code{\link{summarize_tracked_sustainability}()}
}
\concept{Auxiliary Functions}
\keyword{internal}
