% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ahp_pwerror.R
\name{ahp.pwerror}
\alias{ahp.pwerror}
\title{Finds the pairwise comparisons with the maximum amount of inconsistency}
\usage{
ahp.pwerror(ahpmat, atts, npw = 3)
}
\arguments{
\item{ahpmat}{A list of pairwise comparison matrices of each decision maker generated by \code{ahp.mat}.}

\item{atts}{a list of attributes in the correct order}

\item{npw}{Number of pairwise comparisons}
}
\value{
A list of matrices containing \eqn{\epsilon_{ij} = a_{ij}w_{j}/w_{i}} for each decision-maker, with elements from the lower triangle set as NA automatically (since it is essentially equal to the element in the upper triangle).
}
\description{
After constructing a list of matrices with \eqn{\epsilon_{ij} = a_{ij}w_{j}/w_{i}} (following \code{ahp.error}), this algorithm extracts the top \code{n} numbers of pairwise comparison matrices with the highest \eqn{\epsilon_{ij}} for each decision-maker.
}
\examples{

library(magrittr)

atts <- c('cult', 'fam', 'house', 'jobs', 'trans')

data(city200)

cityahp <- ahp.mat(city200, atts, negconvert = TRUE)
ahp.error(cityahp, atts)


}
\references{
\insertRef{Saaty2004}{ahpsurvey}
}
\author{
Frankie Cho
}
