% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frostFreqs.R
\name{frostFreqs}
\alias{frostFreqs}
\title{Frequency of frosts}
\usage{
frostFreqs(mn, dates, thres = 0, out = NULL, iniday = "07-01",
  endday = "06-30")
}
\arguments{
\item{mn}{vector containing the daily minimum temperature series.}

\item{dates}{sequence of daily dates coinciding with temperature data series.}

\item{thres}{temperature threshold considered to trigger frost occurrence (0 by default).}

\item{out}{system path to the generated output file ('.pdf').}

\item{iniday}{first day of the year ("dd-mm") to consider for first and last occurrence of frost.}

\item{endday}{last day of the year ("dd-mm") to consider for first and last occurrence of frost.}
}
\value{
If the output path is defined, a pdf file is created.
}
\description{
This function calculates the frequency of frost occurrence, by month.
}
\details{
Despite the logical threshold of temperature is 0 ºC to determine frost occurrence, the argument "thres" is open to change in case of different units of temperature.
}
\examples{
\donttest{
frostFreqs(mn = daily_tmin, dates = seq.Date(as.Date('1981-01-01'),
                             as.Date('2010-12-31'), by ='day'), thres = 0)
}
}
