% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/afttestplot.R
\name{afttestplot}
\alias{afttestplot}
\title{afttestplot}
\usage{
afttestplot(object, path = 50, stdType = "std", quantile = NULL)
}
\arguments{
\item{object}{is a \code{afttest} fit}

\item{path}{A numeric value specifies the number of approximated processes plotted
The default is set to be 100.}

\item{stdType}{A character string specifying if the graph is based on the 
unstandardized test statistics or standardized test statistics
The default is set to be "std".}

\item{quantile}{A numeric vector specifies 5 of five quantiles within the range [0,1]. 
The default is set to be c(0.1,0.25,0.5,0.75,0.9).}
}
\value{
\code{afttestplot} returns a plot based on the \code{testType}:
\describe{
   \item{omni}{an object of the omnibus test is the form of n by n matrix, 
   some quantiles of x, which are used in weight, are plotted for graphs, 
   i.e. 0\%, 10\%, 25\%, 40\%, 50\%, 60\%, 75\%, 90\%, and 100\% are used.}
   \item{link}{an object of the link function test is the form of n by 1 matrix}
   \item{form}{an object of the functional form test is the form of n by 1 matrix}
}
   See the documentation of \pkg{ggplot2} and \pkg{gridExtra} for details.\
}
\description{
afttestplot
}
\examples{
## Simulate data from an AFT model
library(afttest)
library(survival)
datgen <- function(n = 100) {
  z1 <- rbinom(n, 1, 0.5)
  z2 <- rnorm(n)
  e <- rnorm(n)
  tt <- exp(2 + z1 + z2 + e)
  cen <- runif(n, 0, 100)
  data.frame(Time = pmin(tt, cen), status = 1 * (tt < cen),
             z1 = z1, z2 = z2, id = 1:n)
}
set.seed(0)
simdata <- datgen(n = 20)
result <- afttest(Surv(Time, status) ~ z1 + z2, 
                  data = simdata, testType="link", eqType="mns")
afttestplot(result)
}
