% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.R
\name{subject_to}
\alias{subject_to}
\title{Create a collection of constraints}
\usage{
subject_to(...)
}
\arguments{
\item{...}{arbitrary number of (un)conditional constraints}
}
\value{
an object of class \code{\link{ConstraintsCollection}}
}
\description{
\code{subject_to(...)} can be used to generate an object of class
\code{\link{ConstraintsCollection}} from an arbitrary number of (un)conditional
constraints.
}
\examples{
# Define Type one error rate
toer <- expected(ConditionalPower(Normal(), PointMassPrior(0.0, 1)))

# Define Power at delta = 0.4
pow <- expected(ConditionalPower(Normal(), PointMassPrior(0.4, 1)))

# Define expected sample size at delta = 0.4
ess <- expected(ConditionalSampleSize(Normal(), PointMassPrior(0.4, 1)))

# Compute design minimizing ess subject to power and toer constraints
\dontrun{
minimize(
   ess,
   subject_to(
      toer <= 0.025,
      pow  >= 0.9
   ),
   initial_design = TwoStageDesign(50, .0, 2.0, 60.0, 2.0, 5L)
)
}
}
\seealso{
\code{subject_to} can be used for the constraints in
   \code{\link{minimize}}.
}
