% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConditionalSampleSize.R
\docType{class}
\name{ConditionalSampleSize-class}
\alias{ConditionalSampleSize-class}
\alias{ConditionalSampleSize}
\title{Conditional sample size of a design given stage-one outcome}
\usage{
ConditionalSampleSize(dist, prior)
}
\arguments{
\item{dist}{a univariate \code{\link[=DataDistribution-class]{distribution}} object}

\item{prior}{a \code{\link{Prior}} object}
}
\description{
This score simply evaluates \code{n(d, x1)} for a design \code{d} and the
first-stage outcome \code{x1}.
The data distribution and prior are only relevant when it is integrated.
}
\examples{
css <- ConditionalSampleSize(dist = Normal(), prior = PointMassPrior(.4, 1))

}
\seealso{
The method \code{\link{evaluate}} provides evaluation of the
   \code{ConditionalSampleSize}.
}
