% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_param_framingham.R
\name{derive_param_framingham}
\alias{derive_param_framingham}
\title{Adds a Parameter for Framingham Heart Study Cardiovascular Disease
10-Year Risk Score}
\usage{
derive_param_framingham(
  dataset,
  by_vars,
  set_values_to = exprs(PARAMCD = "FCVD101"),
  sysbp_code = "SYSBP",
  chol_code = "CHOL",
  cholhdl_code = "CHOLHDL",
  age = AGE,
  sex = SEX,
  smokefl = SMOKEFL,
  diabetfl = DIABETFL,
  trthypfl = TRTHYPFL,
  get_unit_expr,
  filter = NULL
)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by the \code{by_vars} argument are expected to be in the dataset.
\code{PARAMCD}, and \code{AVAL} are expected as well.

The variable specified by \code{by_vars} and \code{PARAMCD} must be a unique key of
the input dataset after restricting it by the filter condition (\code{filter}
parameter) and to the parameters specified by \code{sysbp_code}, \code{chol_code}
and \code{hdl_code}.}

\item{by_vars}{Grouping variables

Only variables specified in \code{by_vars} will be populated
in the newly created records.

\emph{Permitted Values}: list of variables created by \code{exprs()}
e.g. \code{exprs(USUBJID, VISIT)}}

\item{set_values_to}{Variables to be set

The specified variables are set to the specified values for the new
observations. For example \code{exprs(PARAMCD = "MAP")} defines the parameter code
for the new parameter.

\emph{Permitted Values}: List of variable-value pairs}

\item{sysbp_code}{Systolic blood pressure parameter code

The observations where \code{PARAMCD} equals the specified value are considered
as the systolic blood pressure assessments.

\emph{Permitted Values:} character value}

\item{chol_code}{Total serum cholesterol code

The observations where \code{PARAMCD} equals the specified value are considered
as the total cholesterol assessments. This must be measured in mg/dL.

\emph{Permitted Values:} character value}

\item{cholhdl_code}{HDL serum cholesterol code

The observations where \code{PARAMCD} equals the specified value are considered
as the HDL cholesterol assessments. This must be measured in mg/dL.

\emph{Permitted Values:} character value}

\item{age}{Subject age

A variable containing the subject's age.

\emph{Permitted Values:} A numeric variable name that refers to a subject age
column of the input dataset}

\item{sex}{Subject sex

A variable containing the subject's sex.

\emph{Permitted Values:} A character variable name that refers to a subject sex
column of the input dataset}

\item{smokefl}{Smoking status flag

A flag indicating smoking status.

\emph{Permitted Values:} A character variable name that refers to a smoking status
column of the input dataset.}

\item{diabetfl}{Diabetic flag

A flag indicating diabetic status.

\emph{Permitted Values:} A character variable name that refers to a diabetic
status column of the input dataset}

\item{trthypfl}{Treated with hypertension medication flag

A flag indicating if a subject was treated with hypertension medication.

\emph{Permitted Values:} A character variable name that refers to a column that
indicates whether a subject is treated for high blood
pressure}

\item{get_unit_expr}{An expression providing the unit of the parameter

The result is used to check the units of the input parameters.

Permitted Values: A variable of the input dataset or a function call}

\item{filter}{Filter condition

The specified condition is applied to the input dataset before deriving the
new parameter, i.e., only observations fulfilling the condition are taken
into account.

\emph{Permitted Values:} a condition}
}
\value{
The input dataset with the new parameter added
}
\description{
Adds a record for framingham score (FCVD101) for each by group
(e.g., subject and visit) where the source parameters are available.
}
\details{
The values of \code{age}, \code{sex}, \code{smokefl}, \code{diabetfl} and \code{trthypfl} will be
added to the \code{by_vars} list.
The predicted probability of having cardiovascular disease (CVD)
within 10-years according to Framingham formula. See AHA Journal article
General Cardiovascular Risk Profile for Use in Primary Care for reference.

\strong{For Women:}

\tabular{rr}{
\strong{Factor} \tab \strong{Amount} \cr
Age \tab 2.32888 \cr
Total Chol \tab 1.20904 \cr
HDL Chol \tab -0.70833 \cr
Sys BP \tab 2.76157 \cr
Sys BP + Hypertension Meds \tab 2.82263 \cr
Smoker \tab 0.52873 \cr
Non-Smoker \tab 0 \cr
Diabetic \tab 0.69154 \cr
Not Diabetic \tab 0 \cr
Average Risk \tab 26.1931 \cr
Risk Period \tab 0.95012 \cr
}

\strong{For Men:}

\tabular{rr}{
\strong{Factor} \tab \strong{Amount} \cr
Age \tab 3.06117 \cr
Total Chol \tab 1.12370 \cr
HDL Chol \tab -0.93263 \cr
Sys BP \tab 1.93303 \cr
Sys BP + Hypertension Meds \tab 2.99881 \cr
Smoker \tab .65451  \cr
Non-Smoker \tab 0 \cr
Diabetic \tab 0.57367  \cr
Not Diabetic \tab 0 \cr
Average Risk \tab 23.9802 \cr
Risk Period \tab 0.88936 \cr
}

\strong{The equation for calculating risk:}

\deqn{RiskFactors = (log(Age) * AgeFactor)
+ (log(TotalChol) * TotalCholFactor)
+ (log(CholHDL) * CholHDLFactor) \\
+ (log(SysBP) * SysBPFactor) + Smoker
+ Diabetes Present - AvgRisk}

\deqn{Risk = 100 * (1 - RiskPeriodFactor^{RiskFactors})}
}
\examples{
library(tibble)

adcvrisk <- tribble(
  ~USUBJID, ~PARAMCD, ~PARAM, ~AVAL, ~AVALU,
  ~VISIT, ~AGE, ~SEX, ~SMOKEFL, ~DIABETFL, ~TRTHYPFL,
  "01-701-1015", "SYSBP", "Systolic Blood Pressure (mmHg)", 121,
  "mmHg", "BASELINE", 44, "F", "N", "N", "N",
  "01-701-1015", "SYSBP", "Systolic Blood Pressure (mmHg)", 115,
  "mmHg", "WEEK 2", 44, "F", "N", "N", "Y",
  "01-701-1015", "CHOL", "Total Cholesterol (mg/dL)", 216.16,
  "mg/dL", "BASELINE", 44, "F", "N", "N", "N",
  "01-701-1015", "CHOL", "Total Cholesterol (mg/dL)", 210.78,
  "mg/dL", "WEEK 2", 44, "F", "N", "N", "Y",
  "01-701-1015", "CHOLHDL", "Cholesterol/HDL-Cholesterol (mg/dL)", 54.91,
  "mg/dL", "BASELINE", 44, "F", "N", "N", "N",
  "01-701-1015", "CHOLHDL", "Cholesterol/HDL-Cholesterol (mg/dL)", 26.72,
  "mg/dL", "WEEK 2", 44, "F", "N", "N", "Y",
  "01-701-1028", "SYSBP", "Systolic Blood Pressure (mmHg)", 119,
  "mmHg", "BASELINE", 55, "M", "Y", "Y", "Y",
  "01-701-1028", "SYSBP", "Systolic Blood Pressure (mmHg)", 101,
  "mmHg", "WEEK 2", 55, "M", "Y", "Y", "Y",
  "01-701-1028", "CHOL", "Total Cholesterol (mg/dL)", 292.01,
  "mg/dL", "BASELINE", 55, "M", "Y", "Y", "Y",
  "01-701-1028", "CHOL", "Total Cholesterol (mg/dL)", 246.73,
  "mg/dL", "WEEK 2", 55, "M", "Y", "Y", "Y",
  "01-701-1028", "CHOLHDL", "Cholesterol/HDL-Cholesterol (mg/dL)", 65.55,
  "mg/dL", "BASELINE", 55, "M", "Y", "Y", "Y",
  "01-701-1028", "CHOLHDL", "Cholesterol/HDL-Cholesterol (mg/dL)", 44.62,
  "mg/dL", "WEEK 2", 55, "M", "Y", "Y", "Y"
)


adcvrisk \%>\%
  derive_param_framingham(
    by_vars = exprs(USUBJID, VISIT),
    set_values_to = exprs(
      PARAMCD = "FCVD101",
      PARAM = "FCVD1-Framingham CVD 10-Year Risk Score (\%)"
    ),
    get_unit_expr = AVALU
  )

derive_param_framingham(
  adcvrisk,
  by_vars = exprs(USUBJID, VISIT),
  set_values_to = exprs(
    PARAMCD = "FCVD101",
    PARAM = "FCVD1-Framingham CVD 10-Year Risk Score (\%)"
  ),
  get_unit_expr = extract_unit(PARAM)
)
}
\seealso{
\code{\link[=compute_framingham]{compute_framingham()}}

BDS-Findings Functions for adding Parameters/Records: 
\code{\link{default_qtc_paramcd}()},
\code{\link{derive_expected_records}()},
\code{\link{derive_extreme_event}()},
\code{\link{derive_extreme_records}()},
\code{\link{derive_locf_records}()},
\code{\link{derive_param_bmi}()},
\code{\link{derive_param_bsa}()},
\code{\link{derive_param_computed}()},
\code{\link{derive_param_doseint}()},
\code{\link{derive_param_exist_flag}()},
\code{\link{derive_param_exposure}()},
\code{\link{derive_param_map}()},
\code{\link{derive_param_qtc}()},
\code{\link{derive_param_rr}()},
\code{\link{derive_param_wbc_abs}()},
\code{\link{derive_summary_records}()}
}
\concept{der_prm_bds_findings}
\keyword{der_prm_bds_findings}
