% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_extreme_date.R
\name{date_source}
\alias{date_source}
\title{Create a \code{date_source} object}
\usage{
date_source(
  dataset_name,
  filter = NULL,
  date,
  date_imputation = deprecated(),
  time_imputation = deprecated(),
  preserve = deprecated(),
  traceability_vars = NULL
)
}
\arguments{
\item{dataset_name}{The name of the dataset, i.e. a string, used to search for
the date.}

\item{filter}{An unquoted condition for filtering \code{dataset}.}

\item{date}{A variable providing a date. A date or a datetime can be
specified. An unquoted symbol is expected.}

\item{date_imputation}{\emph{Deprecated}, please use \code{derive_vars_dtm()} to
convert DTC variables to datetime variables in the dataset.}

\item{time_imputation}{\emph{Deprecated}, please use \code{derive_vars_dtm()} to
convert DTC variables to datetime variables in the dataset.}

\item{preserve}{\emph{Deprecated}, please use \code{derive_vars_dtm()} to convert DTC
variables to datetime variables in the dataset.}

\item{traceability_vars}{A named list returned by \code{vars()} defining the
traceability variables, e.g. \code{vars(LALVDOM = "AE", LALVSEQ = AESEQ, LALVVAR = "AESTDTC")}. The values must be a symbol, a character string, a numeric,
or \code{NA}.}
}
\value{
An object of class \code{date_source}.
}
\description{
Create a \code{date_source} object as input for \code{derive_var_extreme_dt()} and
\code{derive_var_extreme_dtm()}.
}
\examples{

# treatment end date from ADSL
trt_end_date <- date_source(
  dataset_name = "adsl",
  date = TRTEDT
)

# lab date from LB where assessment was taken, i.e. not "NOT DONE"
lb_date <- date_source(
  dataset_name = "lb",
  filter = LBSTAT != "NOT DONE" | is.na(LBSTAT),
  date = LBDT
)

# death date from ADSL including traceability variables
death_date <- date_source(
  dataset_name = "adsl",
  date = DTHDT,
  traceability_vars = vars(
    LALVDOM = "ADSL",
    LALVVAR = "DTHDT"
  )
)
}
\seealso{
\code{\link[=derive_var_extreme_dtm]{derive_var_extreme_dtm()}}, \code{\link[=derive_var_extreme_dt]{derive_var_extreme_dt()}}

Source Specifications: 
\code{\link{assert_db_requirements}()},
\code{\link{assert_terms}()},
\code{\link{assert_valid_queries}()},
\code{\link{basket_select}()},
\code{\link{censor_source}()},
\code{\link{death_event}},
\code{\link{dthcaus_source}()},
\code{\link{event_source}()},
\code{\link{extend_source_datasets}()},
\code{\link{filter_date_sources}()},
\code{\link{format.basket_select}()},
\code{\link{list_tte_source_objects}()},
\code{\link{params}()},
\code{\link{query}()},
\code{\link{sdg_select}()},
\code{\link{smq_select}()},
\code{\link{tte_source}()},
\code{\link{validate_basket_select}()},
\code{\link{validate_query}()}
}
\author{
Stefan Bundfuss
}
\concept{source_specifications}
\keyword{source_specifications}
