% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_query_data.R
\name{basket_select}
\alias{basket_select}
\title{Create a \code{basket_select} object}
\usage{
basket_select(name = NULL, id = NULL, scope = NULL, type)
}
\arguments{
\item{name}{Name of the query used to select the definition of the query from
the company database.}

\item{id}{Identifier of the query used to select the definition of the query
from the company database.}

\item{scope}{Scope of the query used to select the definition of the query
from the company database.

\emph{Permitted Values}: \code{"BROAD"}, \code{"NARROW"}, \code{NA_character_}}

\item{type}{The type argument expects a character scalar. It is passed to the
company specific get_terms() function such that the function can determine
which sort of basket is requested}
}
\value{
An object of class \code{basket_select}.
}
\description{
Create a \code{basket_select} object
}
\details{
Exactly one of \code{name} or \code{id} must be specified.
}
\seealso{
\code{\link[=create_query_data]{create_query_data()}}, \code{\link[=query]{query()}}

Source Specifications: 
\code{\link{assert_db_requirements}()},
\code{\link{assert_terms}()},
\code{\link{assert_valid_queries}()},
\code{\link{censor_source}()},
\code{\link{date_source}()},
\code{\link{death_event}},
\code{\link{dthcaus_source}()},
\code{\link{event_source}()},
\code{\link{extend_source_datasets}()},
\code{\link{filter_date_sources}()},
\code{\link{format.basket_select}()},
\code{\link{list_tte_source_objects}()},
\code{\link{params}()},
\code{\link{query}()},
\code{\link{sdg_select}()},
\code{\link{smq_select}()},
\code{\link{tte_source}()},
\code{\link{validate_basket_select}()},
\code{\link{validate_query}()}
}
\author{
Tamara Senior
}
\concept{source_specifications}
\keyword{source_specifications}
