% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_basetype.R
\name{derive_var_basetype}
\alias{derive_var_basetype}
\title{Derive BASETYPE Variable}
\usage{
derive_var_basetype(dataset, basetypes)
}
\arguments{
\item{dataset}{Input dataset

The columns specified in the expressions inside \code{basetypes} are required.}

\item{basetypes}{A \emph{named} list of expressions created using the
\code{rlang::exprs()} function

The names corresponds to the values of the newly created \code{BASETYPE} variables
and the expressions are used to subset the input dataset.}
}
\value{
The input dataset with variable \code{BASETYPE} added
}
\description{
Baseline Type \code{BASETYPE} is needed when there is more than one definition of
baseline for a given Analysis Parameter \code{PARAM} in the same dataset.  For a
given parameter, if Baseline Value \code{BASE} is populated, and there is more than
one definition of baseline, then \code{BASETYPE} must be non-null on all records of
any type for that parameter. Each value of \code{BASETYPE} refers to a definition of
baseline that characterizes the value of \code{BASE} on that row.  Please see
section 4.2.1.6 of the ADaM Implementation Guide, version 1.3 for further
background.
}
\details{
Adds the \code{BASETYPE} variable to a dataset and duplicates records based upon
the provided conditions.

For each element of \code{basetypes} the input dataset is subset based upon
the provided expression and the \code{BASETYPE} variable is set to the name of the
expression. Then, all subsets are stacked. Records which do not match any
condition are kept and \code{BASETYPE} is set to \code{NA}.
}
\examples{
bds <- tibble::tribble(
  ~USUBJID, ~EPOCH,         ~PARAMCD,  ~ASEQ, ~AVAL,
  "P01",    "RUN-IN",       "PARAM01",     1,  10.0,
  "P01",    "RUN-IN",       "PARAM01",     2,   9.8,
  "P01",    "DOUBLE-BLIND", "PARAM01",     3,   9.2,
  "P01",    "DOUBLE-BLIND", "PARAM01",     4,  10.1,
  "P01",    "OPEN-LABEL",   "PARAM01",     5,  10.4,
  "P01",    "OPEN-LABEL",   "PARAM01",     6,   9.9,
  "P02",    "RUN-IN",       "PARAM01",     1,  12.1,
  "P02",    "DOUBLE-BLIND", "PARAM01",     2,  10.2,
  "P02",    "DOUBLE-BLIND", "PARAM01",     3,  10.8,
  "P02",    "OPEN-LABEL",   "PARAM01",     4,  11.4,
  "P02",    "OPEN-LABEL",   "PARAM01",     5,  10.8
)

bds_with_basetype <- derive_var_basetype(
  dataset = bds,
  basetypes = rlang::exprs(
    "RUN-IN" = EPOCH \%in\% c("RUN-IN", "STABILIZATION", "DOUBLE-BLIND", "OPEN-LABEL"),
    "DOUBLE-BLIND" = EPOCH \%in\% c("DOUBLE-BLIND", "OPEN-LABEL"),
    "OPEN-LABEL" = EPOCH == "OPEN-LABEL"
  )
)


# Below print statement will print all 23 records in the data frame
# bds_with_basetype
print(bds_with_basetype, n = Inf)

dplyr::count(bds_with_basetype, BASETYPE, name = "Number of Records")

# An example where all parameter records need to be included for 2 different
# baseline type derivations (such as LAST and WORST)
bds <- tibble::tribble(
  ~USUBJID, ~EPOCH,         ~PARAMCD,  ~ASEQ, ~AVAL,
  "P01",    "RUN-IN",       "PARAM01",     1,  10.0,
  "P01",    "RUN-IN",       "PARAM01",     2,   9.8,
  "P01",    "DOUBLE-BLIND", "PARAM01",     3,   9.2,
  "P01",    "DOUBLE-BLIND", "PARAM01",     4,  10.1
)

bds_with_basetype <- derive_var_basetype(
  dataset = bds,
  basetypes = rlang::exprs(
    "LAST" = TRUE,
    "WORST" = TRUE
  )
)

print(bds_with_basetype, n = Inf)

dplyr::count(bds_with_basetype, BASETYPE, name = "Number of Records")
}
\seealso{
BDS-Findings Functions that returns variable appended to dataset: 
\code{\link{derive_var_analysis_ratio}()},
\code{\link{derive_var_anrind}()},
\code{\link{derive_var_atoxgr_dir}()},
\code{\link{derive_var_atoxgr}()},
\code{\link{derive_var_base}()},
\code{\link{derive_var_chg}()},
\code{\link{derive_var_ontrtfl}()},
\code{\link{derive_var_pchg}()},
\code{\link{derive_var_shift}()}
}
\author{
Thomas Neitmann
}
\concept{der_bds_findings}
\keyword{der_bds_findings}
