#' Single Dose Exposure Dataset
#'
#' A derived dataset with single dose per date.
#'
#' @source
#' Derived from the `ex` dataset using `{admiral}` and `{dplyr}` (\url{https://github.com/pharmaverse/admiral/blob/main/inst/example_scripts/derive_single_dose.R})
"ex_single"

#' Queries Dataset
#'
#' An example of standard query dataset to be used in deriving variables in ADAE and ADCM
#'
"queries"

#' Subject Level Analysis Dataset
#'
#' An example subject level analysis dataset
#'
#' @source
#' Derived from the `dm` and `ds` datasets using `{admiral}` (\url{https://github.com/pharmaverse/admiral/blob/main/inst/templates/ad_adsl.R})
#'
"admiral_adsl"

#' Adverse Event Analysis Dataset
#'
#' An example adverse event analysis dataset
#'
#' @source
#' Derived from the `adsl` and `ae` datasets using `{admiral}` (\url{https://github.com/pharmaverse/admiral/blob/main/inst/templates/ad_adae.R})
#'
"admiral_adae"

#' Concomitant Medication Analysis Dataset
#'
#' An example concomitant medication analysis dataset
#'
#' @source
#' Derived from the `adsl` and `cm` datasets using `{admiral}` (\url{https://github.com/pharmaverse/admiral/blob/main/inst/templates/ad_adcm.R})
#'
"admiral_adcm"

#' Exposure Analysis Dataset
#'
#' An example exposure analysis dataset
#'
#' @source
#' Derived from the `adsl` and `ex` datasets using `{admiral}` (\url{https://github.com/pharmaverse/admiral/blob/main/inst/templates/ad_adex.R})
#'
"admiral_adex"

#' ECG Analysis Dataset
#'
#' An example ECG analysis dataset
#'
#' @source
#' Derived from the `adsl` and `eg` datasets using `{admiral}` (\url{https://github.com/pharmaverse/admiral/blob/main/inst/templates/ad_adeg.R})
#'
"admiral_adeg"

#' Vital Signs Analysis Dataset
#'
#' An example vital signs analysis dataset
#'
#' @source
#' Derived from the `adsl` and `vs` datasets using `{admiral}` (\url{https://github.com/pharmaverse/admiral/blob/main/inst/templates/ad_advs.R})
#'
"admiral_advs"

#' Pharmacokinetics Parameters Analysis Dataset
#'
#' An example pharmacokinetics parameters analysis dataset
#'
#' @source
#' Derived from the `adsl` and `pp` datasets using `{admiral}` (\url{https://github.com/pharmaverse/admiral/blob/main/inst/templates/ad_adpp.R})
#'
"admiral_adpp"
