% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_param_tte.R
\name{tte_source}
\alias{tte_source}
\title{Create a \code{tte_source} Object}
\usage{
tte_source(dataset_name, filter = NULL, date, censor = 0, set_values_to = NULL)
}
\arguments{
\item{dataset_name}{The name of the source dataset

The name refers to the dataset provided by the \code{source_datasets} parameter
of \code{derive_param_tte()}.}

\item{filter}{An unquoted condition for selecting the observations from
\code{dataset} which are events or possible censoring time points.}

\item{date}{A variable providing the date of the event or censoring. A date,
a datetime, or a character variable containing ISO 8601 dates can be
specified. An unquoted symbol is expected.}

\item{censor}{Censoring value

CDISC strongly recommends using \code{0} for events and positive integers for
censoring.}

\item{set_values_to}{A named list returned by \code{vars()} defining the variables
to be set for the event or censoring, e.g. \code{vars(EVENTDESC = "DEATH", SRCDOM = "ADSL", SRCVAR = "DTHDT")}. The values must be a symbol, a
character string, a numeric value, or \code{NA}.}
}
\value{
An object of class \code{tte_source}
}
\description{
The \code{tte_source} object is used to define events and possible censorings.
}
\seealso{
\code{\link[=derive_param_tte]{derive_param_tte()}}, \code{\link[=censor_source]{censor_source()}}, \code{\link[=event_source]{event_source()}}
}
\author{
Stefan Bundfuss
}
\keyword{dev_utility}
