% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_trtdurd.R
\name{derive_var_trtdurd}
\alias{derive_var_trtdurd}
\title{Derive Total Treatment Duration (Days)}
\usage{
derive_var_trtdurd(dataset, start_date = TRTSDT, end_date = TRTEDT)
}
\arguments{
\item{dataset}{Input dataset

The columns specified by the \code{start_date} and the \code{end_date} parameter are
expected.}

\item{start_date}{The start date

A date or date-time object is expected.

Default: \code{TRTSDT}}

\item{end_date}{The end date

A date or date-time object is expected.

Default: \code{TRTEDT}}
}
\value{
The input dataset with \code{TRTDURD} added
}
\description{
Derives total treatment duration (days) (\code{TRTDURD})
}
\details{
The total treatment duration is derived as the number of days from start to
end date plus one.
}
\examples{
data <- tibble::tribble(
  ~TRTSDT, ~TRTEDT,
  lubridate::ymd("2020-01-01"), lubridate::ymd("2020-02-24")
)

derive_var_trtdurd(data)
}
\seealso{
\code{\link[=derive_vars_duration]{derive_vars_duration()}}
}
\author{
Stefan Bundfuss
}
\keyword{adsl}
\keyword{derivation}
\keyword{timing}
