% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_basetype.R
\name{derive_var_basetype}
\alias{derive_var_basetype}
\title{Derive BASETYPE Variable}
\usage{
derive_var_basetype(dataset, basetypes)
}
\arguments{
\item{dataset}{Input dataset

The columns specified in the expressions inside \code{basetypes} are required.}

\item{basetypes}{A \emph{named} list of expressions created using the
\code{exprs} function

The names corresponds to the values of the newly created \code{BASETYPE} variables
and the expressions are used to subset the input dataset.}
}
\value{
The input dataset with variable \code{BASETYPE} added
}
\description{
Adds the \code{BASETYPE} variable to a dataset and duplicates records based upon
the provided conditions
}
\details{
For each element of \code{basetypes} the input dataset is subset based upon
the provided expression and the \code{BASETYPE} variable is set to the name of the
expression. Then, all subsets are stacked. Records which do not match any
condition are kept and \code{BASETYPE} is set to \code{NA}.
}
\examples{
bds <- tibble::tribble(
  ~USUBJID, ~EPOCH,         ~PARAMCD,  ~ASEQ, ~AVAL,
  "P01",    "RUN-IN",       "PARAM01", 1,     10,
  "P01",    "RUN-IN",       "PARAM01", 2,      9.8,
  "P01",    "DOUBLE-BLIND", "PARAM01", 3,      9.2,
  "P01",    "DOUBLE-BLIND", "PARAM01", 4,     10.1,
  "P01",    "OPEN-LABEL",   "PARAM01", 5,     10.4,
  "P01",    "OPEN-LABEL",   "PARAM01", 6,      9.9,
  "P02",    "RUN-IN",       "PARAM01", 1,     12.1,
  "P02",    "DOUBLE-BLIND", "PARAM01", 2,     10.2,
  "P02",    "DOUBLE-BLIND", "PARAM01", 3,     10.8,
  "P02",    "OPEN-LABEL",   "PARAM01", 4,     11.4,
  "P02",    "OPEN-LABEL",   "PARAM01", 5,     10.8
)

bds_with_basetype <- derive_var_basetype(
  dataset = bds,
  basetypes = exprs(
    "RUN-IN" = EPOCH \%in\% c("RUN-IN", "STABILIZATION", "DOUBLE-BLIND", "OPEN-LABEL"),
    "DOUBLE-BLIND" = EPOCH \%in\% c("DOUBLE-BLIND", "OPEN-LABEL"),
    "OPEN-LABEL" = EPOCH == "OPEN-LABEL"
  )
)
print(bds_with_basetype)

dplyr::count(bds_with_basetype, BASETYPE, name = "Number of Records")
}
\author{
Thomas Neitmann
}
\keyword{bds}
\keyword{derivation}
