% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_status.R
\name{plot_status}
\alias{plot_status}
\alias{plot_status.trial_results}
\title{Plot statuses}
\usage{
plot_status(object, x_value = "look", arm = NULL, area = list(alpha = 0.5))

\method{plot_status}{trial_results}(object, x_value = "look", arm = NULL, area = list(alpha = 0.5))
}
\arguments{
\item{object}{\code{trial_results} object, output from the \link{run_trials} function.}

\item{x_value}{single character string, determining whether the number of
adaptive analysis looks (\code{"look"}, default) or the total cumulated number of
patients allocated (\code{"total n"}) are plotted on the x-axis.}

\item{arm}{single character string or \code{NULL} (default); can be set to a valid
trial \code{arm}. If \code{NULL}, the overall trial statuses are plotted, otherwise
the statuses for a single, specific trial arm are plotted.}

\item{area}{list of styling settings for the area as per \pkg{ggplot2}
conventions (e.g., \code{alpha}, \code{size}). The default (\code{list(alpha = 0.5)}) sets
the transparency to 50\% so overlain shaded areas are visible.}
}
\value{
A \code{ggplot2} plot object.
}
\description{
Plots the statuses over time of multiple simulated trials (overall or for a
specific arm). Requires the \code{ggplot2} package installed.
}
\examples{
#### Only run examples if ggplot2 is installed ####
if (requireNamespace("ggplot2", quietly = TRUE)){

  # Setup a trial specification
  binom_trial <- setup_trial_binom(arms = c("A", "B", "C", "D"),
                                   control = "A",
                                   true_ys = c(0.20, 0.18, 0.22, 0.24),
                                   data_looks = 1:20 * 100)

  # Run multiple simulation with a fixed random base seed
  res_mult <- run_trials(binom_trial, n_rep = 25, base_seed = 12345)

  # Plot trial statuses at each look according to total allocations
  plot_status(res_mult, x_value = "total n")

  # Do not return/print last plot in documentation
  invisible(NULL)
}

}
\seealso{
\link{plot_history}.
}
