% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptivegpca-package.R
\name{gpcaFullFamily}
\alias{gpcaFullFamily}
\title{Make a sequence of ordinations}
\usage{
gpcaFullFamily(X, Q, weights = rep(1, nrow(X)), k = 2, rvec = (0:100)/100,
  findReflections = TRUE, returnLong = FALSE, sampledata = NULL,
  variabledata = NULL)
}
\arguments{
\item{X}{A data matrix of size \eqn{n \times p}.}

\item{Q}{A \eqn{p \times p} similarity matrix defining an inner
product on the rows of \code{X}.}

\item{weights}{A vector of weights for the rows of \code{X}.}

\item{k}{The number of components to compute for each ordination.}

\item{rvec}{The values of \eqn{r} for which to make the ordinations.}

\item{findReflections}{Whether or not flip the axes so as to make
neighboring ordinations as close as possible. If \code{k} is very
large this should be false since all possible axis combinations are
searched over.}

\item{returnLong}{Return a long data frame with the
samples/variables instead of a list of data frames.}

\item{sampledata}{Extra sample data to be included along with the
sample scores.}

\item{variabledata}{Extra variable data to be included along with
the variable loadings.}
}
\value{
A list containing elements for the sample points
(\code{locationList}), the species points (\code{speciesList}), and
the variance fractions (\code{varsList}). Each element is itself a
list of data frames (location/species points) or of vectors (for
the variances).
}
\description{
Creates a sequence of gPCA data representations. One end of the
sequence (\eqn{r = 0}) doesn't do any regularization according to
the variable structure (and so is just standard PCA), and the other
(\eqn{r = 1}) does a maximal amount of regularization according to
the variable structure.
}
\examples{
data(AntibioticSmall)
out.ff = gpcaFullFamily(AntibioticSmall$X, AntibioticSmall$Q, k = 2)
}
