% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_outl_degree.R
\name{do_outl_degree}
\alias{do_outl_degree}
\title{Degree of outlierness}
\usage{
do_outl_degree(vect_tol = c(0.95, 0.9, 0.85), resid_vect, alpha = 0.05, 
               outl_degree = c("outl_strong", "outl_semi_strong", "outl_moderate"))
}
\arguments{
\item{vect_tol}{Vector the tolerance values. Default c(0.95, 0.9, 0.85).}

\item{resid_vect}{Vector of n residuals, where n was the number of rows
of the data matrix.}

\item{alpha}{Significance level. Default 0.05.}

\item{outl_degree}{Type of outlier to identify the degree of outlierness.
Default c("outl_strong", "outl_semi_strong", "outl_moderate").}
}
\value{
List with the type outliers.
}
\description{
Classification of outliers according to their degree of outlierness.
They are classified using the tolerance proportion. For instance,
outliers from a 95% tolerance can be considered strong outliers.
}
\examples{
do_outl_degree(0.95, 1:100, 0.05, "outl_strong")
                                                     
}
\seealso{
\code{\link{outl_toler}}
}
\author{
Guillermo Vinue
}
