% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_S_Star_Plus_MethodB.R
\name{est_S_Star_Plus_MethodB}
\alias{est_S_Star_Plus_MethodB}
\title{Estimate the treatment effects for population S_*+ using Method B}
\usage{
est_S_Star_Plus_MethodB(X, A, Z, Y, TRT)
}
\arguments{
\item{X}{Matrix of baseline variables. Each row contains the baseline values
for each patient across multiple time points.}

\item{A}{Matrix of indicator for adherence. Each row  of A contains the
adherence information for each patient. Each column contains the adherence
indicator after each intermediate time point. A = 1 means adherence and A=0
means non-adherence. Monotone missing is assumed.}

\item{Z}{List of matrices. Intermediate efficacy and safety outcomes that can
affect the probability of adherence. For each matrix, the structure is the
same as variable X.}

\item{Y}{Numeric vector of the final outcome (E.g., primary endpoint).}

\item{TRT}{Numeric vector of treatment assignment. TRT=0 for the control
group and TRT =1 for the experimental treatment group.}
}
\value{
A list containing the following components:
  \item{trt_diff}{Estimate of treatment difference for S_{*+} using Method B}
  \item{se}{Estimated standard error}
  \item{res1}{Estimated mean for the treatment group}
  \item{res0}{Estimated mean for the control group}
  \item{se_res1}{Estimated standard error for the treatment group}
  \item{se_res0}{Estimated standard error for the control group}

#' @details
The average treatment difference can be denoted as

\deqn{latex}{\mu_{d,*+} = E\{Y(1)-Y(0)|A(1) = 1\}}

The method B exploits the joint distribution of X, Z, and A to estimate the
probability that a patient would adhere to the hypothetical alternative
treatment, and then use IPW to estimate treatment different for a given
population. The variance estimation for the treatment effect is constructed
using the sandwich method. Details can be found in the references.

The intermediate post-baseline measurements for each intermediate time point
are estimated by regressing Z on X using subjects with experimental treatment
or placebo. The covariance matrix is estimated based on the residuals of
the regression.

The probability of adherence is estimated by
regressing A on X, Z by using all data. The logistic regression is used in
this function.

The indicator of adherence prior to the first intermediate time point is not
included in this model since this function assumes no intercurrent events
prior to the first time point. Thus,  the first element of Z should not have
missing values.

Each element of Z contains the variables at each intermediate time point,
i.e., the first element of Z contains the intermediate variables at time
point 1, the second element contains the intermediate variables at time point
 2, etc.
}
\description{
The est_S_Star_Plus_MethodB function produces estimation of treatment
 effects for the population that can adhere to the experimental
 treatment (S_*+). This method (Method B) is based on the potential outcome
 under the hypothetical alternative treatment .
}
\examples{
 library(MASS)
 n = 1000
 alpha1 = matrix(rep(c(2.3, -0.3, -0.01, 0.02, 0.03, 0.04, -0.4),3),ncol=3)
 alpha2 = matrix(rep(c(2.3, -0.3, -0.01, 0.02, 0.03, 0.04, -0.9),4),ncol=4)
 alpha3 = matrix(rep(c(2.3, -0.3, -0.01, 0.02, 0.03, 0.04, -0.9),5),ncol=5)
 beta = c(0.2, -0.3, -0.01, 0.02, 0.03, 0.04, rep(0.02,3),
 rep(0.04,4), rep(0.07,5))
 beta_T = -0.2
 gamma1 = c(1, -0.1, 0.2, 0.2, 0.2, 0.2, rep(-1/3,3))     #setting 1
 gamma2 = c(1, -0.1, 0.2, 0.2, 0.2, 0.2, rep(-2/4,4))     #setting 1
 gamma3 = c(1, -0.1, 0.2, 0.2, 0.2, 0.2, rep(-2.5/5,5))   #setting 1
 sd_z_x = 0.4
 X = mvrnorm(n, mu=c(1,5,6,7,8), Sigma=diag(1,5))
 TRT = rbinom(n, size = 1,  prob = 0.5)
 Z0_1 = alpha1[1,]+(X\%*\%alpha1[2:6,])           + mvrnorm(n, mu = rep(0,3),
 Sigma = diag(sd_z_x,3))
 Z1_1 = alpha1[1,]+(X\%*\%alpha1[2:6,])+alpha1[7,] + mvrnorm(n, mu = rep(0,3),
 Sigma = diag(sd_z_x,3))
 Z_1  = Z1_1 * TRT+Z0_1 * (1-TRT)

 Z0_2 = alpha2[1,]+(X\%*\%alpha2[2:6,])           + mvrnorm(n, mu = rep(0,4),
 Sigma = diag(sd_z_x,4))
 Z1_2 = alpha2[1,]+(X\%*\%alpha2[2:6,])+alpha2[7,] + mvrnorm(n, mu = rep(0,4),
 Sigma = diag(sd_z_x,4))
 Z_2  = Z1_2 * TRT + Z0_2 * (1-TRT)

 Z0_3 = alpha3[1,]+(X\%*\%alpha3[2:6,])           + mvrnorm(n, mu = rep(0,5),
 Sigma = diag(sd_z_x,5))
 Z1_3 = alpha3[1,]+(X\%*\%alpha3[2:6,])+alpha3[7,] + mvrnorm(n, mu = rep(0,5),
 Sigma = diag(sd_z_x,5))
 Z_3  = Z1_3 * TRT + Z0_3 * (1-TRT)
 Z = list(Z_1, Z_2, Z_3)
 Y0 = (beta[1]+(X \%*\% beta[2:6]) + Z0_1 \%*\% matrix(beta[7:9], ncol = 1) +
 Z0_2 \%*\% matrix(beta[10:13], ncol = 1) + Z0_3 \%*\% beta[14:18] +
 rnorm(n, mean = 0, sd = 0.3))[,1]
 Y1 = (beta[1] + (X \%*\% beta[2:6]) + Z1_1 \%*\% matrix(beta[7:9], ncol = 1) +
 Z1_2 \%*\% matrix(beta[10:13], ncol = 1) + Z1_3 \%*\% beta[14:18] + beta_T +
 rnorm(n, mean = 0, sd = 0.3))[,1]
 Y  = Y1 * TRT + Y0 * (1 - TRT)

 A0_1 = rbinom(n, size = 1, prob = 1 / (1 + exp(-(gamma1[1] +
 (X \%*\% gamma1[2:6]) + Z0_1 \%*\% matrix(gamma1[7:9], ncol = 1))[,1])))
 A1_1 = rbinom(n, size = 1, prob = 1/(1 + exp(-(gamma1[1] +
 (X \%*\% gamma1[2:6]) + Z1_1 \%*\% matrix(gamma1[7:9], ncol = 1))[,1])))
 A_1  = A1_1 * TRT + A0_1 * (1 - TRT)

 A0_2 = rbinom(n, size = 1, prob = 1/(1 + exp(-(gamma2[1] +
 (X \%*\% gamma2[2:6]) + Z0_2 \%*\% matrix(gamma2[7:10], ncol = 1))[,1]))) * A0_1
 A1_2 = rbinom(n, size = 1, prob = 1/(1 + exp(-(gamma2[1] +
 (X \%*\% gamma2[2:6]) + Z1_2 \%*\% matrix(gamma2[7:10], ncol = 1))[,1]))) * A1_1
 A_2  = A1_2 * TRT + A0_2 * (1 - TRT)

 A0_3 = rbinom(n, size = 1, prob = 1/(1 + exp(-(gamma3[1] +
 (X \%*\% gamma3[2:6]) + Z0_3 \%*\% matrix(gamma3[7:11], ncol = 1))[,1]))) * A0_2
 A1_3 = rbinom(n, size = 1, prob = 1/(1 + exp(-(gamma3[1] +
 (X \%*\% gamma3[2:6]) + Z1_3 \%*\% matrix(gamma3[7:11], ncol = 1))[,1]))) * A1_2
 A_3  = A1_3 * TRT + A0_3 * (1 - TRT)
 A = cbind(A_1, A_2, A_3)

 Z[[2]][A_1 == 0] <- NA
 Z[[3]][A_2 == 0] <- NA
 Y[A_3 == 0]   <- NA
 # estimate the treatment difference
 fit <- est_S_Star_Plus_MethodA(X, A, Z, Y, TRT)
 fit
 # Calculate the true values
 true1 =  mean(Y1[A1_3 == 1])
 true1
 true0 =  mean(Y0[A1_3 == 1])
 true0
 true_d  =  true1 - true0
 true_d

}
\references{
Qu, Yongming, et al. "A general framework for treatment effect estimators
considering patient adherence." Statistics in Biopharmaceutical Research
12.1 (2020): 1-18.

Zhang, Ying, et al. "Statistical inference on the estimators of the adherer
average causal effect."
Statistics in Biopharmaceutical Research (2021): 1-4.
}
