% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transactions.R
\name{add_transactions}
\alias{add_transactions}
\title{Add transactions to an experience study}
\usage{
add_transactions(
  .data,
  trx_data,
  col_pol_num = "pol_num",
  col_trx_date = "trx_date",
  col_trx_type = "trx_type",
  col_trx_amt = "trx_amt"
)
}
\arguments{
\item{.data}{A data frame with exposure-level records with the class
\code{exposed_df}. Use \code{\link[=as_exposed_df]{as_exposed_df()}} to convert a data frame to an
\code{exposed_df} object if necessary.}

\item{trx_data}{A data frame containing transactions details. This data
frame must have columns for policy numbers, transaction dates, transaction
types, and transaction amounts.}

\item{col_pol_num}{Name of the column in \code{trx_data} containing the policy
number}

\item{col_trx_date}{Name of the column in \code{trx_data} containing the
transaction date}

\item{col_trx_type}{Name of the column in \code{trx_data} containing the
transaction type}

\item{col_trx_amt}{Name of the column in \code{trx_data} containing the
transaction amount}
}
\value{
An \code{exposed_df} object with two new columns containing transaction
counts and amounts for each transaction type found in \code{trx_data}. The
\code{exposed_df}'s \code{trx_types} attributes will be updated to include the new
transaction types found in \code{trx_data.}
}
\description{
Attach summarized transactions to a data frame with
exposure-level records.
}
\details{
This function attaches transactions to an \code{exposed_df} object.
Transactions are grouped and summarized such that the number of rows in
the \code{exposed_df} object does not change. Two columns are added to the output
for each transaction type. These columns have names of the pattern
\verb{trx_n_\{*\}} (transaction counts) and \verb{trx_amt_\{*\}} (transaction_amounts).

Transactions are associated with the \code{exposed_df} object by matching
transactions dates with exposure dates ranges found in \code{exposed_df}.
}
\examples{
expo <- expose_py(census_dat, "2019-12-31", target_status = "Surrender")
add_transactions(expo, withdrawals)

}
\seealso{
\code{\link[=expose]{expose()}}, \code{\link[=as_exposed_df]{as_exposed_df()}}
}
