# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Equivalent of \code{\link[activegp]{C_GP}} using RcppArmadillo
#' @param design A matrix of design points, one in each row
#' @param response A vector of observations at each design point. 
#' @param theta vector of lengthscales
#' @param Ki inverse covariance matrix
#' @param ct Covariance type, 1 means Gaussian, 2 means Matern 3/2, 3 means Matern 5/2
#' @return The active subspace matrix C. 
#' @export
#' @keywords internal
C_GP_cpp <- function(design, response, theta, Ki, ct) {
    .Call('_activegp_C_GP_cpp', PACKAGE = 'activegp', design, response, theta, Ki, ct)
}

d_gauss_cpp <- function(X, x, sigma) {
    .Call('_activegp_d_gauss_cpp', PACKAGE = 'activegp', X, x, sigma)
}

d_mat52_cpp <- function(X, x, sigma) {
    .Call('_activegp_d_mat52_cpp', PACKAGE = 'activegp', X, x, sigma)
}

d_mat32_cpp <- function(X, x, sigma) {
    .Call('_activegp_d_mat32_cpp', PACKAGE = 'activegp', X, x, sigma)
}

#' int_0_1 k(x, x') dx
#' @param a design location
#' @param t lengthscale parameter
#' @noRd
NULL

#' int_0_1 dk(x,x')/dx dx
#' @param a design location
#' @param t lengthscale parameter
#' @noRd
NULL

#' int_0_1( d_k(x,a)/dx * d_k(b,x) dx) (univariate)
#' @param a,b design locations
#' @param t lengthscale parameter
#' @param ct Covariance type, 1 means Gaussian, 2 means Matern 3/2, 3 means Matern 5/2
#' @return The scalar integrated derivative as a double.
#' @noRd
w_ii_lebesgue <- function(a, b, t, ct) {
    .Call('_activegp_w_ii_lebesgue', PACKAGE = 'activegp', a, b, t, ct)
}

#' int_0_1( d_k(x,a)/dx * d_k(b,x) dnu(x)) (univariate), where nu is the TRUNCATED Gaussian measure with mean xm and variance xv.
#' @param a,b design locations
#' @param t lengthscale parameter
#' @param ct Covariance type, 1 means Gaussian, 2 means Matern 3/2, 3 means Matern 5/2
#' @param xm the mean of the gaussian measure
#' @param xv the variance of the gaussian measure
#' @return The scalar integrated derivative as a double.
#' @noRd
w_ii_tgauss <- function(a, b, t, ct, xm, xv) {
    .Call('_activegp_w_ii_tgauss', PACKAGE = 'activegp', a, b, t, ct, xm, xv)
}

#' int_0_1( d_k(x,a)/dx * d_k(b,x) dnu(x)) (univariate), where nu is the Gaussian measure with mean xm and variance xv.
#' @param a,b design locations
#' @param t lengthscale parameter
#' @param ct Covariance type, 1 means Gaussian, 2 means Matern 3/2, 3 means Matern 5/2
#' @param xm the mean of the gaussian measure
#' @param xv the variance of the gaussian measure
#' @return The scalar integrated derivative as a double.
#' @noRd
w_ii_gauss <- function(a, b, t, ct, xm, xv) {
    .Call('_activegp_w_ii_gauss', PACKAGE = 'activegp', a, b, t, ct, xm, xv)
}

#' Gradient of int_0_1( d_k(x,a)/dx * d_k(b,x) dx) (univariate) with respect to a.
#' @param a,b design locations
#' @param t lengthscale parameter
#' @param ct Covariance type, 1 means Gaussian, 2 means Matern 3/2, 3 means Matern 5/2
#' @return The scalar integrated derivative as a double.
#' @noRd
grad_w_ii_lebesguea <- function(a, b, t, ct) {
    .Call('_activegp_grad_w_ii_lebesguea', PACKAGE = 'activegp', a, b, t, ct)
}

#' Gradient of int_0_1( d_k(x,a)/dx * d_k(b,x) dx) (univariate) with respect to b.
#' @param a,b design locations
#' @param t lengthscale parameter
#' @param ct Covariance type, 1 means Gaussian, 2 means Matern 3/2, 3 means Matern 5/2
#' @return The scalar integrated derivative as a double. 
#' @noRd
grad_w_ii_lebesgueb <- function(a, b, t, ct) {
    .Call('_activegp_grad_w_ii_lebesgueb', PACKAGE = 'activegp', a, b, t, ct)
}

#' gradient of w_ii with respect to t (univariate)
#' @param a,b design locations
#' @param t lengthscale parameter
#' @param ct Covariance type, 1 means Gaussian, 2 means Matern 3/2, 3 means Matern 5/2
#' @return The the derivative of the scalar integrated derivative as a double.
#' @noRd
grad_w_ii_dt_cpp <- function(a, b, t, ct) {
    .Call('_activegp_grad_w_ii_dt_cpp', PACKAGE = 'activegp', a, b, t, ct)
}

#' int_0_1( d_k(x, a)/dx_i k(b, x) dx) (univariate)
#' @param a,b design locations
#' @param t lengthscale parameter
#' @param ct Covariance type, 1 means Gaussian, 2 means Matern 3/2, 3 means Matern 5/2
#' @return The scalar integrated derivative as a double.
#' @noRd
w_ij_lebesgue <- function(a, b, t, ct) {
    .Call('_activegp_w_ij_lebesgue', PACKAGE = 'activegp', a, b, t, ct)
}

#' int_0_1( d_k(x, a)/dx_i k(b, x) dnu(x)) (univariate), with nu a TRUNCATED gaussian measure with mean xm and variance xv.
#' @param a,b design locations
#' @param t lengthscale parameter
#' @param ct Covariance type, 1 means Gaussian, 2 means Matern 3/2, 3 means Matern 5/2
#' @param xm the mean of the gaussian measure
#' @param xv the variance of the gaussian measure
#' @return The scalar integrated derivative as a double.
#' @noRd
w_ij_tgauss <- function(a, b, t, ct, xm, xv) {
    .Call('_activegp_w_ij_tgauss', PACKAGE = 'activegp', a, b, t, ct, xm, xv)
}

#' int_0_1( d_k(x, a)/dx_i k(b, x) dnu(x)) (univariate), with nu a gaussian measure with mean xm and variance xv.
#' @param a,b design locations
#' @param t lengthscale parameter
#' @param ct Covariance type, 1 means Gaussian, 2 means Matern 3/2, 3 means Matern 5/2
#' @param xm the mean of the gaussian measure
#' @param xv the variance of the gaussian measure
#' @return The scalar integrated derivative as a double.
#' @noRd
w_ij_gauss <- function(a, b, t, ct, xm, xv) {
    .Call('_activegp_w_ij_gauss', PACKAGE = 'activegp', a, b, t, ct, xm, xv)
}

#' int_0_1( d_k(x, a)/dx_i k(b, x) dx) (univariate)
#' @param a,b design locations
#' @param t lengthscale parameter
#' @param ct Covariance type, 1 means Gaussian, 2 means Matern 3/2, 3 means Matern 5/2
#' @return The scalar integrated derivative as a double.
#' @noRd
grad_w_ij_lebesguea <- function(a, b, t, ct) {
    .Call('_activegp_grad_w_ij_lebesguea', PACKAGE = 'activegp', a, b, t, ct)
}

#' int_0_1( d_k(x, a)/dx_i k(b, x) dx) (univariate)
#' @param a,b design locations
#' @param t lengthscale parameter
#' @param ct Covariance type, 1 means Gaussian, 2 means Matern 3/2, 3 means Matern 5/2
#' @return The scalar integrated derivative as a double.
#' @noRd
grad_w_ij_lebesgueb <- function(a, b, t, ct) {
    .Call('_activegp_grad_w_ij_lebesgueb', PACKAGE = 'activegp', a, b, t, ct)
}

#' gradient of w_ij with respect to t (univariate)
#' @param a,b design locations
#' @param t lengthscale parameter
#' @param ct Covariance type, 1 means Gaussian, 2 means Matern 3/2, 3 means Matern 5/2
#' @return The the derivative of the scalar integrated derivative as a double.
#' @noRd
grad_w_ij_dt_cpp <- function(a, b, t, ct) {
    .Call('_activegp_grad_w_ij_dt_cpp', PACKAGE = 'activegp', a, b, t, ct)
}

#' int_0_1 k(x, a) * k(b, x) dx
#' @noRd
Ikk_lebesgue <- function(a, b, t, ct) {
    .Call('_activegp_Ikk_lebesgue', PACKAGE = 'activegp', a, b, t, ct)
}

#' int_0_1 k(x, a) * k(b, x) dnu(x), where nu is the TRUNCATED gaussian measure with mean xm and variance xv
#' @param a,b design locations
#' @param t lengthscale parameter
#' @param ct Covariance type, 1 means Gaussian, 2 means Matern 3/2, 3 means Matern 5/2
#' @param xm the mean of the gaussian measure
#' @param xv the variance of the gaussian measure
#' @noRd
Ikk_tgauss <- function(a, b, t, ct, xm, xv) {
    .Call('_activegp_Ikk_tgauss', PACKAGE = 'activegp', a, b, t, ct, xm, xv)
}

#' int_R k(x, a) * k(b, x) dx, where nu is the gaussian maeasure with mean xm and variance xv
#' @param a,b design locations
#' @param t lengthscale parameter
#' @param ct Covariance type, 1 means Gaussian, 2 means Matern 3/2, 3 means Matern 5/2
#' @param xm the mean of the gaussian measure
#' @param xv the variance of the gaussian measure
#' @noRd
Ikk_gauss <- function(a, b, t, ct, xm, xv) {
    .Call('_activegp_Ikk_gauss', PACKAGE = 'activegp', a, b, t, ct, xm, xv)
}

#' Derivative of int_0_1 k(x, a) * k(b, x) dx With respect to a.
#' @noRd
grad_Ikk_lebesguea <- function(a, b, t, ct) {
    .Call('_activegp_grad_Ikk_lebesguea', PACKAGE = 'activegp', a, b, t, ct)
}

#' Derivative of int_0_1 k(x, a) * k(b, x) dx With respect to b.
#' @noRd
grad_Ikk_lebesgueb <- function(a, b, t, ct) {
    .Call('_activegp_grad_Ikk_lebesgueb', PACKAGE = 'activegp', a, b, t, ct)
}

#' gradient of Ikk with respect to t (univariate)
#' @param a,b design locations
#' @param t lengthscale parameter
#' @param ct Covariance type, 1 means Gaussian, 2 means Matern 3/2, 3 means Matern 5/2
#' @return The the derivative of the scalar integrated derivative as a double.
#' @noRd
grad_Ikk_dt_cpp <- function(a, b, t, ct) {
    .Call('_activegp_grad_Ikk_dt_cpp', PACKAGE = 'activegp', a, b, t, ct)
}

#' Computes Int(kappa_i(X, design) . kappa_j(design, X)). This function is preferred for initialization
#' @title Covariance of kernel computations
#' @param design matrix of design points
#' @param theta lengthscales
#' @param i1,i2 index of the derivatives (WARNING: starts at 0)
#' @param ct Covariance type, 1 means Gaussian, 2 means Matern 3/2, 3 means Matern 5/2
#' @return The matrix representing the result of the integration.
#' @export
#' @keywords internal
W_kappa_ij <- function(design, theta, i1, i2, ct) {
    .Call('_activegp_W_kappa_ij', PACKAGE = 'activegp', design, theta, i1, i2, ct)
}

#' Creates a submatrix of the same tensor as W_kappa_ij, but this time l,k give the indices of the observations, not variables.
#' @title Covariance of kernel computations
#' @param design matrix of design points
#' @param theta lengthscales
#' @param i1,i2 index of the observations (WARNING: starts at 0)
#' @param ct Covariance type, 1 means Gaussian, 2 means Matern 3/2, 3 means Matern 5/2
#' @return The matrix representing the result of the integration.
#' @export
#' @keywords internal
W_kappa_lk <- function(design, theta, i1, i2, ct) {
    .Call('_activegp_W_kappa_lk', PACKAGE = 'activegp', design, theta, i1, i2, ct)
}

#' Computes Int(kappa_i(X, design1) . kappa_j(design2, X)). This function is preferred for initialization
#' @title Covariance of kernel computations 
#' @param design1,design2 matrices of design points
#' @param theta lengthscales
#' @param i1,i2 index of the derivatives (WARNING: starts at 0)
#' @param ct Covariance type, 1 means Gaussian, 2 means Matern 3/2, 3 means Matern 5/2
#' @return matrix of size nrow(design1) x nrow(design2)
#' @keywords internal
W_kappa_ij2 <- function(design1, design2, theta, i1, i2, ct) {
    .Call('_activegp_W_kappa_ij2', PACKAGE = 'activegp', design1, design2, theta, i1, i2, ct)
}

#' Computes gradient of Int(kappa_i(X, design1) . kappa_j(design2, X)) with respect to the first argument.
#' @title Covariance of kernel computations 
#' @param design1 A vector representing a new point.
#' @param design2 matrices of design points
#' @param theta lengthscales
#' @param i1,i2 index of the derivatives (WARNING: starts at 0)
#' @param ct Covariance type, 1 means Gaussian, 2 means Matern 3/2, 3 means Matern 5/2
#' @return matrix of size nrow(design1) x nrow(design2)
#' @keywords internal
grad_W_kappa_ij2 <- function(design1, design2, theta, i1, i2, ct) {
    .Call('_activegp_grad_W_kappa_ij2', PACKAGE = 'activegp', design1, design2, theta, i1, i2, ct)
}

#' Computes gradient of Int(kappa_i(X, design1) . kappa_j(design2, X)) with respect to the second argument.
#' @title Covariance of kernel computations 
#' @param design1 A vector representing a new point.
#' @param design2 matrices of design points
#' @param theta lengthscales
#' @param i1,i2 index of the derivatives (WARNING: starts at 0)
#' @param ct Covariance type, 1 means Gaussian, 2 means Matern 3/2, 3 means Matern 5/2
#' @return matrix of size nrow(design1) x nrow(design2)
#' @keywords internal
grad_W_kappa_ij2_w2 <- function(design1, design2, theta, i1, i2, ct) {
    .Call('_activegp_grad_W_kappa_ij2_w2', PACKAGE = 'activegp', design1, design2, theta, i1, i2, ct)
}

#' Computes Int(kappa_i(X, design) . kappa_j(design, X)). This function is preferred for updates
#' @title Covariance of kernel computations
#' @param W The matrix to store the computation in
#' @param design matrix of design points
#' @param theta lengthscales
#' @param i1,i2 index of the derivatives (WARNING: starts at 0)
#' @param start The column/row index at which to start the computation (doesn't touch the start by start submatrix).
#' @param ct Covariance type, 1 means Gaussian, 2 means Matern 3/2, 3 means Matern 5/2
#' @return W is modified in-place.
#' @keywords internal
#' @export
W_kappa_ij_up <- function(W, design, theta, i1, i2, start, ct) {
    invisible(.Call('_activegp_W_kappa_ij_up', PACKAGE = 'activegp', W, design, theta, i1, i2, start, ct))
}

#' Computes Int(kappa_i(X, design) . kappa_j(design, X)). This function is preferred for initialization
#' @title Covariance of kernel computations
#' @param measure An integer giving the measure of integration. 0 for Lebesgue/Uniform on [0,1]^m, 1 for (truncated) Gaussian on [0,1]^m, 2 for Gaussian on R^m.
#' @param design matrix of design points
#' @param Ki The inverse covariance matrix
#' @param Kir The inverse covariance matrix times the response.
#' @param theta lengthscales
#' @param ct Covariance type, 1 means Gaussian, 2 means Matern 3/2, 3 means Matern 5/2
#' @param xm The mean vector associated with the Gaussian measure. Ignored if uniform. 
#' @param xv The variance vector associated with the Gaussian measure (diagonal of covariance matrix, vars assumed independent). Ignored if uniform. 
#' @return The matrix representing the result of the integration.
#' @export
#' @keywords internal
quick_C <- function(measure, design, Ki, Kir, theta, xm, xv, ct, verbose) {
    .Call('_activegp_quick_C', PACKAGE = 'activegp', measure, design, Ki, Kir, theta, xm, xv, ct, verbose)
}

#' Derivative of the W matrix wrt theta
#' @param design matrix of design points, one per row, in [0,1]^d
#' @param theta Gaussian kernel hyperparameters (TODO: define parameterization)
#' @param W W matrix matrix
#' @param i1,i2 index of C[i1,i2]
#' @param it :index of theta for partial derivative
#' @param ct : covariance type (only 1 is supported for now)
#' @noRd
grad_W_t <- function(design, theta, W, i1, i2, it, ct) {
    .Call('_activegp_grad_W_t', PACKAGE = 'activegp', design, theta, W, i1, i2, it, ct)
}

