% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotArray}
\alias{plotArray}
\title{Plot simultaneous/cumulative presences at a give array or set of arrays}
\usage{
plotArray(
  input,
  arrays,
  title,
  xlab,
  ylab,
  lwd = 1,
  col = "#56B4E9",
  type = c("default", "bars", "lines"),
  timestep = c("days", "hours", "mins"),
  cumulative = FALSE
)
}
\arguments{
\item{input}{The results of an actel analysis (either explore, migration or residency).}

\item{arrays}{One or more arrays to be analysed. If multiple arrays are provided, data will be grouped.}

\item{title}{An optional title for the plot.}

\item{xlab, ylab}{Optional axis names for the plot. If left empty, default axis names will be added.}

\item{lwd}{The line width, only relevant for line plots.}

\item{col}{The colour of the line or bars. Defaults to blue.}

\item{type}{The type of plot to be drawn. By default, a line is plotted if cumulative = TRUE, and bars are plotted otherwise.}

\item{timestep}{The time resolution for the grouping of the results. Defaults to "days", but can be set to "hours" and "mins" (at the expense of computing time).}

\item{cumulative}{Logical. If TRUE, a cumulative plot of arrivals is drawn, otherwise the number of tags simultaneously present at the array(s) is drawn.}
}
\value{
A ggplot object.
}
\description{
Plot simultaneous/cumulative presences at a give array or set of arrays
}
\examples{
# Using the example results that come with actel
plotArray(example.results, arrays = "A9")

# Because plotArray returns a ggplot object, you can store
# it and edit it manually, e.g.:
library(ggplot2)
p <- plotArray(example.results, arrays = "A9")
p <- p + xlab("changed the x axis label a posteriori")
p

# You can also save the plot using ggsave!

}
