% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{myRoseDiag}
\alias{myRoseDiag}
\title{Edited rose diagram function}
\usage{
myRoseDiag(
  x,
  pch = 16,
  cex = 1,
  axes = TRUE,
  shrink = 1,
  bins = 24,
  upper = TRUE,
  ticks = TRUE,
  tcl = 0.025,
  tcl.text = 0.125,
  radii.scale = c("sqrt", "linear"),
  border = NULL,
  col = c("lightblue", "#c0ff3e80", "#ffc0cb80", "#F0E4424D", "#0072B24D", "#D55E004D"),
  tol = 0.04,
  uin = NULL,
  xlim = c(-1, 1),
  ylim = c(-1, 1),
  prop = 1,
  digits = 2,
  plot.info = NULL,
  units = NULL,
  template = NULL,
  zero = NULL,
  rotation = NULL,
  main = NULL,
  sub = NULL,
  xlab = "",
  ylab = "",
  add = TRUE,
  control.circle = circular::circle.control(),
  rings = c("none", "absolute", "relative"),
  rings.lty = 2,
  ring.text = FALSE,
  ring.text.pos = -0.04,
  ring.text.cex = 1
)
}
\arguments{
\item{x}{a vector, matrix or data.frame. The object is coerced to class circular.}

\item{pch}{point character to use. See help on par.}

\item{cex}{point character size. See help on par.}

\item{axes}{logical: if TRUE axes are plotted according to properties of x.}

\item{shrink}{parameter that controls the size of the plotted circle. Default is 1. Larger values shrink the circle, while smaller values enlarge the circle.}

\item{bins}{number of arcs to partition the circle with.}

\item{upper}{logical: if TRUE, the rose diagram cells are "upper"-closed intervals.}

\item{ticks}{logical: if TRUE ticks are plotted according to the value of bins.}

\item{tcl}{length of the ticks.}

\item{tcl.text}{the position of the axis labels.}

\item{radii.scale}{make possible to choose sector radius form: square-root of relative frequency (sqrt, default) or conventional linear scale (linear).}

\item{border}{the colour to draw the border. The default, NULL, means to use par("fg"). Use border = NA to omit borders.}

\item{col}{the colour for filling the rose diagram. The default, NULL, is to leave rose diagram unfilled. The values are recycled if needed.}

\item{tol}{proportion of white space at the margins of plot.}

\item{uin}{desired values for the units per inch parameter. If of length 1, the desired units per inch on the x axis.}

\item{xlim, ylim}{the ranges to be encompassed by the x and y axes. Useful for centring the plot}

\item{prop}{numerical constant determining the radii of the sectors. By default, prop = 1.}

\item{digits}{number of digits used to print axis values.}

\item{plot.info}{an object from plot.circular that contains information on the zero, the rotation and next.points.}

\item{units}{the units used in the plot. If NULL the units of the first component of 'x' is used.}

\item{template}{the template of the plot. Ignored if plot.info is provided.}

\item{zero}{the zero of the plot. Ignored if plot.info or template are provided.}

\item{rotation}{the rotation of the plot. Ignored if plot.info or template are provided.}

\item{main, sub, xlab, ylab}{title, subtitle, x label and y label of the plot.}

\item{add}{add the rose diag to an existing plot.}

\item{control.circle}{parameters passed to plot.default in order to draw the circle. The function circle.control is used to set the parameters.}

\item{rings}{logical: if TRUE, inner rings are displayed for visual reference}

\item{rings.lty}{line type of the rings, See help on par.}

\item{ring.text}{logical: if notes should be displayed.}

\item{ring.text.pos}{The position of the rings' text. Ignored if ring.text is set to FALSE.}

\item{ring.text.cex}{The size of the ring's text. Ignored if ring.text is set to FALSE.}
}
\value{
A list with the zero, rotation and next.points values, to be parsed to an overlaying graphic.
}
\description{
Adapted from the \code{\link[circular]{rose.diag}} function of the circular package.
}
\details{
For more details about the original function, visit the circular package homepage at \url{https://github.com/cran/circular}.
}
\keyword{internal}
