% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{dataToList}
\alias{dataToList}
\title{Import RData in a list format}
\usage{
dataToList(source)
}
\arguments{
\item{source}{A RData file.}
}
\value{
A list containing the objects present in the source RData file.
}
\description{
Import RData in a list format
}
\examples{
# Dummy example:
# Create two objects:
object_1 <- "This"
object_2 <- "Worked!"

# Save them as an RData file in R's temporary directory
save(object_1, object_2, file = paste0(tempdir(), "/dataToList_example.RData"))

# Remove the dummy objects as we don't need them any more
rm(object_1, object_2)

# Load the RData file as a single object
x <- dataToList(paste0(tempdir(), "/dataToList_example.RData"))

# inspect x
x

}
