% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decay_exponential.R
\name{decay_exponential}
\alias{decay_exponential}
\title{Negative exponential decay function}
\usage{
decay_exponential(decay_value)
}
\arguments{
\item{decay_value}{A \code{numeric} vector. The calibration parameters that, when
multiplied by the travel cost, are used as the exponent of \code{e} in the
negative exponential function.}
}
\value{
A \code{function} that takes a generic travel cost vector (\code{numeric}) as
an input and returns a \code{list} of weight vectors (a list of \code{numeric}
vectors, named after the arguments passed to the decay function).
}
\description{
Returns a negative exponential weighting function to be used inside
accessibility calculating functions.

This function is generic over any kind of numeric travel cost,
such as distance, time and money.
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
weighting_function <- decay_exponential(decay_value = 0.1)

weighting_function(c(20, 30))

weighting_function <- decay_exponential(decay_value = c(0.1, 0.2))

weighting_function(c(20, 30))
\dontshow{\}) # examplesIf}
}
\seealso{
Other decay functions: 
\code{\link{decay_binary}()},
\code{\link{decay_linear}()},
\code{\link{decay_power}()},
\code{\link{decay_stepped}()}
}
\concept{decay functions}
