% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SZVD_ADMM.R
\name{SZVD_ADMM}
\alias{SZVD_ADMM}
\title{Alternating Direction Method of Multipliers for SZVD}
\usage{
SZVD_ADMM(B, N, D, sols0, pen_scal, gamma, beta, tol, maxits, quiet = TRUE)
}
\arguments{
\item{B}{Between class covariance matrix for objective (in space defined by N).}

\item{N}{basis matrix for null space of covariance matrix W.}

\item{D}{penalty dictionary/basis.}

\item{sols0}{initial solutions sols0$x, sols0$y, sols0$z}

\item{pen_scal}{penalty scaling term.}

\item{gamma}{l1 regularization parameter}

\item{beta}{penalty term controlling the splitting constraint.}

\item{tol}{tol$abs = absolute error, tol$rel = relative error to be
achieved to declare convergence of the algorithm.}

\item{maxits}{maximum number of iterations of the algorithm to run.}

\item{quiet}{toggles between displaying intermediate statistics.}
}
\value{
\code{SZVD_ADMM} returns an object of \code{\link{class}} "\code{SZVD_ADMM}" including a list
with the following named components

\describe{
  \item{\code{x,y,z}}{Iterates at termination.}
  \item{\code{its}}{Number of iterations required to converge.}
  \item{\code{errtol}}{Stopping error bound at termination}
}
}
\description{
Iteratively solves the problem
\deqn{\text{min}(-1/2*x^TB^Tx + \gamma p(y): ||x||_2 \leq 1, DNx = y)}{min(-1/2*x^TB^Tx + gamma p(y): l2(x) <= 1, DNx = y)}
}
\details{
This function is used by other functions and should only be called explicitly for
debugging purposes.
}
\seealso{
Used by: \code{\link{SZVDcv}}.
}
\keyword{internal}
