% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abYlm.Mglm.R
\name{abYlm.Mglm}
\alias{abYlm.Mglm}
\title{Adaptive Bootstrap for Mediation Analysis with Linear Models and Generalized Linear Models}
\usage{
abYlm.Mglm(
  S,
  M,
  Y,
  X = NULL,
  covariates_cfder = NULL,
  M.family = stats::gaussian(),
  s = 1,
  s_star = 0,
  B = 199,
  lambda = 2
)
}
\arguments{
\item{S}{an n-by-1 vector for exposure.}

\item{M}{an n-by-1 vector for mediator.}

\item{Y}{an n-by-1 vector for outcome.}

\item{X}{an n-by-p matrix for confounder. Please do not include intercept in X. If you do not have confounder, you do not need specify this parameter.}

\item{covariates_cfder}{a vector of confounders you want to condition on, default is zero. The length of this parameter should equal p, the column dimension of X.}

\item{M.family}{The error distribution and link function for the mediator model. The default family is \code{gaussian()}.}

\item{s}{exposure level, default is 1}

\item{s_star}{another exposure level, default is 0}

\item{B}{the number of bootstrap samples, default is 199}

\item{lambda}{the constant used in the pretest when conducting adaptive bootstrap, default is 2.}
}
\value{
NIE the estimated mediation effect between s and s_star.

p_value_NIE the p value for NIE.

NDE the estimated natural direct effect between s and s_star.

p_value_NDE the p value for NDE.

NTE the estimated natural total (treatment) effect between s and s_star.

p_value_NTE the p value for NTE.
}
\description{
\code{abYlm.Mglm} conducts adaptive bootstrap for mediation analysis with the generalized linear model on the mediator M and the linear model on the outcome Y. The family of the generalized linear model is specified with \code{M.family}.
}
\examples{
\donttest{
  ## Load libraries
  library(abima)

  set.seed(2)

  ## Set up parameters
  M.family <- poisson()

  simulation <- function(alpha_S = 0, beta_M = 0) {
    data <- generate_all_data(
      n = 500,
      alpha_S = alpha_S,
      beta_M = beta_M,
      M.family = M.family
    )
    S <- data$S
    M <- data$M
    Y <- data$Y
    X <- data$X

    out <- abYlm.Mglm(S,
                      M,
                      Y,
                      X,
                      M.family = M.family,
                      lambda = 2,
                      B = 199)
    out
  }


  simulation(1 / 8, 1 / 8)

  simulation(0, 0)

}
}
\references{
He, Y., Song, P. X. K., and Xu, G. (2023), “Adaptive bootstrap tests for composite null hypotheses in the mediation pathway analysis,” Journal of the Royal Statistical Society Series B: Statistical Methodology, qkad129. \url{doi:10.1093/jrsssb/qkad129}.
}
