% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_lm.R
\name{stat_lm}
\alias{stat_lm}
\title{Create an lm stat object.}
\usage{
stat_lm(std.beta = FALSE, complete.cases = TRUE)
}
\arguments{
\item{std.beta}{logical. Whether to standardize model predictors and
covariates prior to analysis.}

\item{complete.cases}{logical. Whether to only include the subset of data
with no missing data for any of the outcomes, predictors, or covariates.
Note that complete cases are considering within each group - outcome
combination but across all predictor sets.}
}
\value{
An abaStat object with \code{lm} stat type.
}
\description{
This function creates a lm stat object which can be passed as input
to the \code{set_stats()} function when building an aba model. This stat performs
a traditional linear regression analysis using the \code{lm} function.
Coefficients will be presented as beta coefficients. Default metrics include
adjusted R2.
}
\examples{

data <- adnimerge \%>\% dplyr::filter(VISCODE == 'bl')

# fit lm model with continuous outcome variables
model <- data \%>\% aba_model() \%>\%
  set_groups(
    everyone(),
    DX_bl \%in\% c('MCI', 'AD')
  ) \%>\%
  set_outcomes(CDRSB_bl, MMSE_bl) \%>\%
  set_predictors(
    PLASMA_ABETA_bl, PLASMA_PTAU181_bl, PLASMA_NFL_bl,
    c(PLASMA_ABETA_bl, PLASMA_PTAU181_bl, PLASMA_NFL_bl)
  ) \%>\%
  set_covariates(AGE, GENDER, EDUCATION) \%>\%
  set_stats(
    stat_lm(std.beta = TRUE)
  ) \%>\%
  fit()

# summarise model
model_summary <- model \%>\% summary()

# plot results
fig1 <- model_summary \%>\% aba_plot_coef()
fig2 <- model_summary \%>\% aba_plot_metric()

}
