% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lucas.R
\name{Lucas}
\alias{Lucas}
\alias{A000032}
\title{Lucas numbers}
\usage{
Lucas(n, gmp = TRUE)
}
\arguments{
\item{n}{the number of first \code{n} entries from the sequence.}

\item{gmp}{a logical; \code{TRUE} to use large number representation, \code{FALSE} otherwise.}
}
\value{
a vector of length \code{n} containing first entries from the sequence.
}
\description{
Under OEIS \href{https://oeis.org/A000032}{A000032}, the \emph{n}th \emph{Lucas} number is given as
\deqn{F_n = F_{n-1} + F_{n-2}}
where the first 6 entries are 2, 1, 3, 4, 7, 11.
}
\examples{
## generate first 30 Lucas numbers
print(Lucas(30))

}
\seealso{
\code{\link{Fibonacci}}
}
