% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Polite.R
\name{Polite}
\alias{Polite}
\alias{A138591}
\title{Polite numbers}
\usage{
Polite(n, Rmpfr = TRUE, PrecisionBits = 496)
}
\arguments{
\item{n}{the number of first \code{n} entries from the sequence.}

\item{Rmpfr}{a logical; \code{TRUE} to use large number representation, \code{FALSE} otherwise.}

\item{PrecisionBits}{a positive integer for precision bits larger than 2.}
}
\value{
a vector of length \code{n} containing first entries from the sequence.
}
\description{
Under OEIS \href{https://oeis.org/A138591}{A138591}, a \emph{Polite} number is a positive integer
that can be written as the sum of two or more consecutive nonnegative numbers. First 6 Frugal numbers are 1, 3, 5, 6, 7, 9.
}
\examples{
## generate first 20 Polite numbers
first20 = Polite(20)

## print without trailing 0's.
print(first20, drop0trailing = TRUE)

}
