#' @name Sunflower_Phomopsis
#' @title Phomopsis stem canker observations for Sunflower
#' @description This dataset contains fraction intercepted photosynthetically active radiation (IPAR) and corresponding percent of girdling lesions at harvest (pclesions) for 43 fields.
#' Phomopsis stem canker is a worldwide fungal disease of sunflower, which causes stem girdling lesions and a consequent reduction in yield.  One wants to decide if the number of girdling lesions at harvest in the absence of early treatment will exceed 15% (Debaeke & Estragnat, 2009). If the answer is yes (population X1) then one should treat, if the answer is no (population X0) then a treatment is not needed. An early indicator of the final number of lesions has been proposed, namely fraction intercepted photosynthetically active radiation (IPAR) at the early E2 growth stage. Larger values of IPAR correspond to greater vegetative development , which leads to higher humidity in the canopy. This in turn favors disease development. We want to quantify the usefulness of early IPAR for determining if the number of girdling lesions at harvest in the absence of early treatment will exceed 15%.
#' This data frame consist of a sample of fields with values for IPAR  (ipar) and for the percent of girdling lesions at harvest (pclesions).
#' @docType data
#' @usage Sunflower_Phomopsis
#' @format a \code{RangedData} instance, 1 row per observation.
#' @source Debaeke, P., & Estragnat, A. (2009). Crop canopy indicators for the early prediction of Phomopsis stem canker (Diaporthe helianthi) in sunflower. Crop Protection, 28(9), 792-801. doi:10.1016/j.cropro.2009.04.011
NULL
