/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.poi.hssf.model.HSSFFormulaParser;
import org.apache.poi.hssf.model.InternalWorkbook;
import org.apache.poi.hssf.record.BlankRecord;
import org.apache.poi.hssf.record.BoolErrRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.HyperlinkRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordBase;
import org.apache.poi.hssf.record.aggregates.FormulaRecordAggregate;
import org.apache.poi.hssf.record.common.UnicodeString;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFErrorConstants;
import org.apache.poi.hssf.usermodel.HSSFHyperlink;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.ptg.ExpPtg;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.FormulaError;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public class HSSFCell
implements Cell {
    private static POILogger log = POILogFactory.getLogger(HSSFCell.class);
    private static final String FILE_FORMAT_NAME = "BIFF8";
    public static final int LAST_COLUMN_NUMBER = SpreadsheetVersion.EXCEL97.getLastColumnIndex();
    private static final String LAST_COLUMN_NAME = SpreadsheetVersion.EXCEL97.getLastColumnName();
    public static final short ENCODING_UNCHANGED = -1;
    public static final short ENCODING_COMPRESSED_UNICODE = 0;
    public static final short ENCODING_UTF_16 = 1;
    private final HSSFWorkbook _book;
    private final HSSFSheet _sheet;
    private int _cellType;
    private HSSFRichTextString _stringValue;
    private CellValueRecordInterface _record;
    private HSSFComment _comment;

    protected HSSFCell(HSSFWorkbook book, HSSFSheet sheet, int row, short col) {
        HSSFCell.checkBounds(col);
        this._stringValue = null;
        this._book = book;
        this._sheet = sheet;
        short xfindex = sheet.getSheet().getXFIndexForColAt(col);
        this.setCellType(3, false, row, col, xfindex);
    }

    @Override
    public HSSFSheet getSheet() {
        return this._sheet;
    }

    @Override
    public HSSFRow getRow() {
        int rowIndex = this.getRowIndex();
        return this._sheet.getRow(rowIndex);
    }

    protected HSSFCell(HSSFWorkbook book, HSSFSheet sheet, int row, short col, int type) {
        HSSFCell.checkBounds(col);
        this._cellType = -1;
        this._stringValue = null;
        this._book = book;
        this._sheet = sheet;
        short xfindex = sheet.getSheet().getXFIndexForColAt(col);
        this.setCellType(type, false, row, col, xfindex);
    }

    protected HSSFCell(HSSFWorkbook book, HSSFSheet sheet, CellValueRecordInterface cval) {
        this._record = cval;
        this._cellType = HSSFCell.determineType(cval);
        this._stringValue = null;
        this._book = book;
        this._sheet = sheet;
        switch (this._cellType) {
            case 1: {
                this._stringValue = new HSSFRichTextString(book.getWorkbook(), (LabelSSTRecord)cval);
                break;
            }
            case 3: {
                break;
            }
            case 2: {
                this._stringValue = new HSSFRichTextString(((FormulaRecordAggregate)cval).getStringValue());
            }
        }
    }

    private static int determineType(CellValueRecordInterface cval) {
        if (cval instanceof FormulaRecordAggregate) {
            return 2;
        }
        Record record = (Record)((Object)cval);
        switch (record.getSid()) {
            case 515: {
                return 0;
            }
            case 513: {
                return 3;
            }
            case 253: {
                return 1;
            }
            case 517: {
                BoolErrRecord boolErrRecord = (BoolErrRecord)record;
                return boolErrRecord.isBoolean() ? 4 : 5;
            }
        }
        throw new RuntimeException("Bad cell value rec (" + cval.getClass().getName() + ")");
    }

    protected InternalWorkbook getBoundWorkbook() {
        return this._book.getWorkbook();
    }

    @Override
    public int getRowIndex() {
        return this._record.getRow();
    }

    public void setCellNum(short num) {
        this._record.setColumn(num);
    }

    protected void updateCellNum(short num) {
        this._record.setColumn(num);
    }

    public short getCellNum() {
        return (short)this.getColumnIndex();
    }

    @Override
    public int getColumnIndex() {
        return this._record.getColumn() & 0xFFFF;
    }

    @Override
    public void setCellType(int cellType) {
        this.notifyFormulaChanging();
        if (this.isPartOfArrayFormulaGroup()) {
            this.notifyArrayFormulaChanging();
        }
        int row = this._record.getRow();
        short col = this._record.getColumn();
        short styleIndex = this._record.getXFIndex();
        this.setCellType(cellType, true, row, col, styleIndex);
    }

    private void setCellType(int cellType, boolean setValue, int row, short col, short styleIndex) {
        if (cellType > 5) {
            throw new RuntimeException("I have no idea what type that is!");
        }
        switch (cellType) {
            case 2: {
                FormulaRecordAggregate frec;
                if (cellType != this._cellType) {
                    frec = this._sheet.getSheet().getRowsAggregate().createFormula(row, col);
                } else {
                    frec = (FormulaRecordAggregate)this._record;
                    frec.setRow(row);
                    frec.setColumn(col);
                }
                if (setValue) {
                    frec.getFormulaRecord().setValue(this.getNumericCellValue());
                }
                frec.setXFIndex(styleIndex);
                this._record = frec;
                break;
            }
            case 0: {
                NumberRecord nrec = null;
                nrec = cellType != this._cellType ? new NumberRecord() : (NumberRecord)this._record;
                nrec.setColumn(col);
                if (setValue) {
                    nrec.setValue(this.getNumericCellValue());
                }
                nrec.setXFIndex(styleIndex);
                nrec.setRow(row);
                this._record = nrec;
                break;
            }
            case 1: {
                LabelSSTRecord lrec;
                if (cellType == this._cellType) {
                    lrec = (LabelSSTRecord)this._record;
                } else {
                    lrec = new LabelSSTRecord();
                    lrec.setColumn(col);
                    lrec.setRow(row);
                    lrec.setXFIndex(styleIndex);
                }
                if (setValue) {
                    String str = this.convertCellValueToString();
                    int sstIndex = this._book.getWorkbook().addSSTString(new UnicodeString(str));
                    lrec.setSSTIndex(sstIndex);
                    UnicodeString us = this._book.getWorkbook().getSSTString(sstIndex);
                    this._stringValue = new HSSFRichTextString();
                    this._stringValue.setUnicodeString(us);
                }
                this._record = lrec;
                break;
            }
            case 3: {
                BlankRecord brec = null;
                brec = cellType != this._cellType ? new BlankRecord() : (BlankRecord)this._record;
                brec.setColumn(col);
                brec.setXFIndex(styleIndex);
                brec.setRow(row);
                this._record = brec;
                break;
            }
            case 4: {
                BoolErrRecord boolRec = null;
                boolRec = cellType != this._cellType ? new BoolErrRecord() : (BoolErrRecord)this._record;
                boolRec.setColumn(col);
                if (setValue) {
                    boolRec.setValue(this.convertCellValueToBoolean());
                }
                boolRec.setXFIndex(styleIndex);
                boolRec.setRow(row);
                this._record = boolRec;
                break;
            }
            case 5: {
                BoolErrRecord errRec = null;
                errRec = cellType != this._cellType ? new BoolErrRecord() : (BoolErrRecord)this._record;
                errRec.setColumn(col);
                if (setValue) {
                    errRec.setValue((byte)15);
                }
                errRec.setXFIndex(styleIndex);
                errRec.setRow(row);
                this._record = errRec;
            }
        }
        if (cellType != this._cellType && this._cellType != -1) {
            this._sheet.getSheet().replaceValueRecord(this._record);
        }
        this._cellType = cellType;
    }

    @Override
    public int getCellType() {
        return this._cellType;
    }

    @Override
    public void setCellValue(double value) {
        if (Double.isInfinite(value)) {
            this.setCellErrorValue(FormulaError.DIV0.getCode());
        } else if (Double.isNaN(value)) {
            this.setCellErrorValue(FormulaError.NUM.getCode());
        } else {
            int row = this._record.getRow();
            short col = this._record.getColumn();
            short styleIndex = this._record.getXFIndex();
            switch (this._cellType) {
                default: {
                    this.setCellType(0, false, row, col, styleIndex);
                }
                case 0: {
                    ((NumberRecord)this._record).setValue(value);
                    break;
                }
                case 2: {
                    ((FormulaRecordAggregate)this._record).setCachedDoubleResult(value);
                }
            }
        }
    }

    @Override
    public void setCellValue(Date value) {
        this.setCellValue(HSSFDateUtil.getExcelDate(value, this._book.getWorkbook().isUsing1904DateWindowing()));
    }

    @Override
    public void setCellValue(Calendar value) {
        this.setCellValue(HSSFDateUtil.getExcelDate(value, this._book.getWorkbook().isUsing1904DateWindowing()));
    }

    @Override
    public void setCellValue(String value) {
        HSSFRichTextString str = value == null ? null : new HSSFRichTextString(value);
        this.setCellValue(str);
    }

    @Override
    public void setCellValue(RichTextString value) {
        HSSFRichTextString hvalue = (HSSFRichTextString)value;
        int row = this._record.getRow();
        short col = this._record.getColumn();
        short styleIndex = this._record.getXFIndex();
        if (hvalue == null) {
            this.notifyFormulaChanging();
            this.setCellType(3, false, row, col, styleIndex);
            return;
        }
        if (hvalue.length() > SpreadsheetVersion.EXCEL97.getMaxTextLength()) {
            throw new IllegalArgumentException("The maximum length of cell contents (text) is 32,767 characters");
        }
        if (this._cellType == 2) {
            FormulaRecordAggregate fr = (FormulaRecordAggregate)this._record;
            fr.setCachedStringResult(hvalue.getString());
            this._stringValue = new HSSFRichTextString(value.getString());
            return;
        }
        if (this._cellType != 1) {
            this.setCellType(1, false, row, col, styleIndex);
        }
        int index = 0;
        UnicodeString str = hvalue.getUnicodeString();
        index = this._book.getWorkbook().addSSTString(str);
        ((LabelSSTRecord)this._record).setSSTIndex(index);
        this._stringValue = hvalue;
        this._stringValue.setWorkbookReferences(this._book.getWorkbook(), (LabelSSTRecord)this._record);
        this._stringValue.setUnicodeString(this._book.getWorkbook().getSSTString(index));
    }

    @Override
    public void setCellFormula(String formula) {
        if (this.isPartOfArrayFormulaGroup()) {
            this.notifyArrayFormulaChanging();
        }
        int row = this._record.getRow();
        short col = this._record.getColumn();
        short styleIndex = this._record.getXFIndex();
        if (formula == null) {
            this.notifyFormulaChanging();
            this.setCellType(3, false, row, col, styleIndex);
            return;
        }
        int sheetIndex = this._book.getSheetIndex(this._sheet);
        Ptg[] ptgs = HSSFFormulaParser.parse(formula, this._book, 0, sheetIndex);
        this.setCellType(2, false, row, col, styleIndex);
        FormulaRecordAggregate agg = (FormulaRecordAggregate)this._record;
        FormulaRecord frec = agg.getFormulaRecord();
        frec.setOptions((short)2);
        frec.setValue(0.0);
        if (agg.getXFIndex() == 0) {
            agg.setXFIndex((short)15);
        }
        agg.setParsedExpression(ptgs);
    }

    private void notifyFormulaChanging() {
        if (this._record instanceof FormulaRecordAggregate) {
            ((FormulaRecordAggregate)this._record).notifyFormulaChanging();
        }
    }

    @Override
    public String getCellFormula() {
        if (!(this._record instanceof FormulaRecordAggregate)) {
            throw HSSFCell.typeMismatch(2, this._cellType, true);
        }
        return HSSFFormulaParser.toFormulaString(this._book, ((FormulaRecordAggregate)this._record).getFormulaTokens());
    }

    private static String getCellTypeName(int cellTypeCode) {
        switch (cellTypeCode) {
            case 3: {
                return "blank";
            }
            case 1: {
                return "text";
            }
            case 4: {
                return "boolean";
            }
            case 5: {
                return "error";
            }
            case 0: {
                return "numeric";
            }
            case 2: {
                return "formula";
            }
        }
        return "#unknown cell type (" + cellTypeCode + ")#";
    }

    private static RuntimeException typeMismatch(int expectedTypeCode, int actualTypeCode, boolean isFormulaCell) {
        String msg = "Cannot get a " + HSSFCell.getCellTypeName(expectedTypeCode) + " value from a " + HSSFCell.getCellTypeName(actualTypeCode) + " " + (isFormulaCell ? "formula " : "") + "cell";
        return new IllegalStateException(msg);
    }

    private static void checkFormulaCachedValueType(int expectedTypeCode, FormulaRecord fr) {
        int cachedValueType = fr.getCachedResultType();
        if (cachedValueType != expectedTypeCode) {
            throw HSSFCell.typeMismatch(expectedTypeCode, cachedValueType, true);
        }
    }

    @Override
    public double getNumericCellValue() {
        switch (this._cellType) {
            case 3: {
                return 0.0;
            }
            case 0: {
                return ((NumberRecord)this._record).getValue();
            }
            default: {
                throw HSSFCell.typeMismatch(0, this._cellType, false);
            }
            case 2: 
        }
        FormulaRecord fr = ((FormulaRecordAggregate)this._record).getFormulaRecord();
        HSSFCell.checkFormulaCachedValueType(0, fr);
        return fr.getValue();
    }

    @Override
    public Date getDateCellValue() {
        if (this._cellType == 3) {
            return null;
        }
        double value = this.getNumericCellValue();
        if (this._book.getWorkbook().isUsing1904DateWindowing()) {
            return HSSFDateUtil.getJavaDate(value, true);
        }
        return HSSFDateUtil.getJavaDate(value, false);
    }

    @Override
    public String getStringCellValue() {
        HSSFRichTextString str = this.getRichStringCellValue();
        return str.getString();
    }

    @Override
    public HSSFRichTextString getRichStringCellValue() {
        switch (this._cellType) {
            case 3: {
                return new HSSFRichTextString("");
            }
            case 1: {
                return this._stringValue;
            }
            default: {
                throw HSSFCell.typeMismatch(1, this._cellType, false);
            }
            case 2: 
        }
        FormulaRecordAggregate fra = (FormulaRecordAggregate)this._record;
        HSSFCell.checkFormulaCachedValueType(1, fra.getFormulaRecord());
        String strVal = fra.getStringValue();
        return new HSSFRichTextString(strVal == null ? "" : strVal);
    }

    @Override
    public void setCellValue(boolean value) {
        int row = this._record.getRow();
        short col = this._record.getColumn();
        short styleIndex = this._record.getXFIndex();
        switch (this._cellType) {
            default: {
                this.setCellType(4, false, row, col, styleIndex);
            }
            case 4: {
                ((BoolErrRecord)this._record).setValue(value);
                break;
            }
            case 2: {
                ((FormulaRecordAggregate)this._record).setCachedBooleanResult(value);
            }
        }
    }

    @Override
    public void setCellErrorValue(byte errorCode) {
        int row = this._record.getRow();
        short col = this._record.getColumn();
        short styleIndex = this._record.getXFIndex();
        switch (this._cellType) {
            default: {
                this.setCellType(5, false, row, col, styleIndex);
            }
            case 5: {
                ((BoolErrRecord)this._record).setValue(errorCode);
                break;
            }
            case 2: {
                ((FormulaRecordAggregate)this._record).setCachedErrorResult(errorCode);
            }
        }
    }

    private boolean convertCellValueToBoolean() {
        switch (this._cellType) {
            case 4: {
                return ((BoolErrRecord)this._record).getBooleanValue();
            }
            case 1: {
                int sstIndex = ((LabelSSTRecord)this._record).getSSTIndex();
                String text = this._book.getWorkbook().getSSTString(sstIndex).getString();
                return Boolean.valueOf(text);
            }
            case 0: {
                return ((NumberRecord)this._record).getValue() != 0.0;
            }
            case 2: {
                FormulaRecord fr = ((FormulaRecordAggregate)this._record).getFormulaRecord();
                HSSFCell.checkFormulaCachedValueType(4, fr);
                return fr.getCachedBooleanValue();
            }
            case 3: 
            case 5: {
                return false;
            }
        }
        throw new RuntimeException("Unexpected cell type (" + this._cellType + ")");
    }

    private String convertCellValueToString() {
        switch (this._cellType) {
            case 3: {
                return "";
            }
            case 4: {
                return ((BoolErrRecord)this._record).getBooleanValue() ? "TRUE" : "FALSE";
            }
            case 1: {
                int sstIndex = ((LabelSSTRecord)this._record).getSSTIndex();
                return this._book.getWorkbook().getSSTString(sstIndex).getString();
            }
            case 0: {
                return NumberToTextConverter.toText(((NumberRecord)this._record).getValue());
            }
            case 5: {
                return HSSFErrorConstants.getText(((BoolErrRecord)this._record).getErrorValue());
            }
            case 2: {
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected cell type (" + this._cellType + ")");
            }
        }
        FormulaRecordAggregate fra = (FormulaRecordAggregate)this._record;
        FormulaRecord fr = fra.getFormulaRecord();
        switch (fr.getCachedResultType()) {
            case 4: {
                return fr.getCachedBooleanValue() ? "TRUE" : "FALSE";
            }
            case 1: {
                return fra.getStringValue();
            }
            case 0: {
                return NumberToTextConverter.toText(fr.getValue());
            }
            case 5: {
                return HSSFErrorConstants.getText(fr.getCachedErrorValue());
            }
        }
        throw new IllegalStateException("Unexpected formula result type (" + this._cellType + ")");
    }

    @Override
    public boolean getBooleanCellValue() {
        switch (this._cellType) {
            case 3: {
                return false;
            }
            case 4: {
                return ((BoolErrRecord)this._record).getBooleanValue();
            }
            default: {
                throw HSSFCell.typeMismatch(4, this._cellType, false);
            }
            case 2: 
        }
        FormulaRecord fr = ((FormulaRecordAggregate)this._record).getFormulaRecord();
        HSSFCell.checkFormulaCachedValueType(4, fr);
        return fr.getCachedBooleanValue();
    }

    @Override
    public byte getErrorCellValue() {
        switch (this._cellType) {
            case 5: {
                return ((BoolErrRecord)this._record).getErrorValue();
            }
            default: {
                throw HSSFCell.typeMismatch(5, this._cellType, false);
            }
            case 2: 
        }
        FormulaRecord fr = ((FormulaRecordAggregate)this._record).getFormulaRecord();
        HSSFCell.checkFormulaCachedValueType(5, fr);
        return (byte)fr.getCachedErrorValue();
    }

    @Override
    public void setCellStyle(CellStyle style) {
        this.setCellStyle((HSSFCellStyle)style);
    }

    public void setCellStyle(HSSFCellStyle style) {
        if (style == null) {
            this._record.setXFIndex((short)15);
            return;
        }
        style.verifyBelongsToWorkbook(this._book);
        short styleIndex = style.getUserStyleName() != null ? this.applyUserCellStyle(style) : style.getIndex();
        this._record.setXFIndex(styleIndex);
    }

    @Override
    public HSSFCellStyle getCellStyle() {
        short styleIndex = this._record.getXFIndex();
        ExtendedFormatRecord xf = this._book.getWorkbook().getExFormatAt(styleIndex);
        return new HSSFCellStyle(styleIndex, xf, this._book);
    }

    protected CellValueRecordInterface getCellValueRecord() {
        return this._record;
    }

    private static void checkBounds(int cellIndex) {
        if (cellIndex < 0 || cellIndex > LAST_COLUMN_NUMBER) {
            throw new IllegalArgumentException("Invalid column index (" + cellIndex + ").  Allowable column range for " + FILE_FORMAT_NAME + " is (0.." + LAST_COLUMN_NUMBER + ") or ('A'..'" + LAST_COLUMN_NAME + "')");
        }
    }

    @Override
    public void setAsActiveCell() {
        int row = this._record.getRow();
        short col = this._record.getColumn();
        this._sheet.getSheet().setActiveCellRow(row);
        this._sheet.getSheet().setActiveCellCol(col);
    }

    public String toString() {
        switch (this.getCellType()) {
            case 3: {
                return "";
            }
            case 4: {
                return this.getBooleanCellValue() ? "TRUE" : "FALSE";
            }
            case 5: {
                return ErrorEval.getText(((BoolErrRecord)this._record).getErrorValue());
            }
            case 2: {
                return this.getCellFormula();
            }
            case 0: {
                if (HSSFDateUtil.isCellDateFormatted(this)) {
                    SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy");
                    return sdf.format(this.getDateCellValue());
                }
                return String.valueOf(this.getNumericCellValue());
            }
            case 1: {
                return this.getStringCellValue();
            }
        }
        return "Unknown Cell Type: " + this.getCellType();
    }

    @Override
    public void setCellComment(Comment comment) {
        if (comment == null) {
            this.removeCellComment();
            return;
        }
        comment.setRow(this._record.getRow());
        comment.setColumn(this._record.getColumn());
        this._comment = (HSSFComment)comment;
    }

    @Override
    public HSSFComment getCellComment() {
        if (this._comment == null) {
            this._comment = this._sheet.findCellComment(this._record.getRow(), this._record.getColumn());
        }
        return this._comment;
    }

    @Override
    public void removeCellComment() {
        HSSFComment comment = this._sheet.findCellComment(this._record.getRow(), this._record.getColumn());
        this._comment = null;
        if (null == comment) {
            return;
        }
        this._sheet.getDrawingPatriarch().removeShape(comment);
    }

    @Override
    public HSSFHyperlink getHyperlink() {
        for (RecordBase rec : this._sheet.getSheet().getRecords()) {
            HyperlinkRecord link;
            if (!(rec instanceof HyperlinkRecord) || (link = (HyperlinkRecord)rec).getFirstColumn() != this._record.getColumn() || link.getFirstRow() != this._record.getRow()) continue;
            return new HSSFHyperlink(link);
        }
        return null;
    }

    @Override
    public void setHyperlink(Hyperlink hyperlink) {
        HSSFHyperlink link = (HSSFHyperlink)hyperlink;
        link.setFirstRow(this._record.getRow());
        link.setLastRow(this._record.getRow());
        link.setFirstColumn(this._record.getColumn());
        link.setLastColumn(this._record.getColumn());
        switch (link.getType()) {
            case 1: 
            case 3: {
                link.setLabel("url");
                break;
            }
            case 4: {
                link.setLabel("file");
                break;
            }
            case 2: {
                link.setLabel("place");
            }
        }
        List<RecordBase> records = this._sheet.getSheet().getRecords();
        int eofLoc = records.size() - 1;
        records.add(eofLoc, link.record);
    }

    @Override
    public int getCachedFormulaResultType() {
        if (this._cellType != 2) {
            throw new IllegalStateException("Only formula cells have cached results");
        }
        return ((FormulaRecordAggregate)this._record).getFormulaRecord().getCachedResultType();
    }

    void setCellArrayFormula(CellRangeAddress range) {
        int row = this._record.getRow();
        short col = this._record.getColumn();
        short styleIndex = this._record.getXFIndex();
        this.setCellType(2, false, row, col, styleIndex);
        Ptg[] ptgsForCell = new Ptg[]{new ExpPtg(range.getFirstRow(), range.getFirstColumn())};
        FormulaRecordAggregate agg = (FormulaRecordAggregate)this._record;
        agg.setParsedExpression(ptgsForCell);
    }

    @Override
    public CellRangeAddress getArrayFormulaRange() {
        if (this._cellType != 2) {
            String ref = new CellReference(this).formatAsString();
            throw new IllegalStateException("Cell " + ref + " is not part of an array formula.");
        }
        return ((FormulaRecordAggregate)this._record).getArrayFormulaRange();
    }

    @Override
    public boolean isPartOfArrayFormulaGroup() {
        if (this._cellType != 2) {
            return false;
        }
        return ((FormulaRecordAggregate)this._record).isPartOfArrayFormula();
    }

    void notifyArrayFormulaChanging(String msg) {
        CellRangeAddress cra = this.getArrayFormulaRange();
        if (cra.getNumberOfCells() > 1) {
            throw new IllegalStateException(msg);
        }
        this.getRow().getSheet().removeArrayFormula(this);
    }

    void notifyArrayFormulaChanging() {
        CellReference ref = new CellReference(this);
        String msg = "Cell " + ref.formatAsString() + " is part of a multi-cell array formula. " + "You cannot change part of an array.";
        this.notifyArrayFormulaChanging(msg);
    }

    private short applyUserCellStyle(HSSFCellStyle style) {
        int styleIndex;
        if (style.getUserStyleName() == null) {
            throw new IllegalArgumentException("Expected user-defined style");
        }
        InternalWorkbook iwb = this._book.getWorkbook();
        int userXf = -1;
        int numfmt = iwb.getNumExFormats();
        for (int i = 0; i < numfmt; i = (int)((short)(i + 1))) {
            ExtendedFormatRecord xf = iwb.getExFormatAt(i);
            if (xf.getXFType() != 0 || xf.getParentIndex() != style.getIndex()) continue;
            userXf = i;
            break;
        }
        if (userXf == -1) {
            ExtendedFormatRecord xfr = iwb.createCellXF();
            xfr.cloneStyleFrom(iwb.getExFormatAt(style.getIndex()));
            xfr.setIndentionOptions((short)0);
            xfr.setXFType((short)0);
            xfr.setParentIndex(style.getIndex());
            styleIndex = (short)numfmt;
        } else {
            styleIndex = userXf;
        }
        return (short)styleIndex;
    }
}

