/*
 * Decompiled with CFR 0.152.
 */
package com.miraisolutions.xlconnect.data;

import com.miraisolutions.xlconnect.ErrorBehavior;
import com.miraisolutions.xlconnect.data.ColumnBuilder;
import com.miraisolutions.xlconnect.data.DataType;
import com.miraisolutions.xlconnect.utils.CellUtils;
import java.util.ArrayList;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;

public class DefaultColumnBuilder
extends ColumnBuilder {
    protected String[] missingValueStrings;
    protected double[] missingValueNumbers;

    public DefaultColumnBuilder(int nrows, boolean forceConversion, boolean takeCached, FormulaEvaluator evaluator, ErrorBehavior onErrorCell, Object[] missingValue, String dateTimeFormat) {
        super(nrows, forceConversion, takeCached, evaluator, onErrorCell, dateTimeFormat);
        int i;
        ArrayList<Double> missingNum = new ArrayList<Double>();
        ArrayList<String> missingStr = new ArrayList<String>();
        for (i = 0; i < missingValue.length; ++i) {
            if (missingValue[i] instanceof String) {
                missingStr.add((String)missingValue[i]);
                continue;
            }
            if (!(missingValue[i] instanceof Double)) continue;
            missingNum.add((Double)missingValue[i]);
        }
        this.missingValueStrings = missingStr.toArray(new String[missingStr.size()]);
        this.missingValueNumbers = new double[missingNum.size()];
        for (i = 0; i < missingNum.size(); ++i) {
            this.missingValueNumbers[i] = (Double)missingNum.get(i);
        }
    }

    protected void handleCell(Cell c, CellValue cv) {
        switch (cv.getCellTypeEnum()) {
            case BLANK: {
                this.addMissing();
                return;
            }
            case BOOLEAN: {
                this.addValue(c, cv, DataType.Boolean);
                break;
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)c)) {
                    this.addValue(c, cv, DataType.DateTime);
                    break;
                }
                boolean missing = false;
                for (int i = 0; i < this.missingValueNumbers.length; ++i) {
                    if (cv.getNumberValue() != this.missingValueNumbers[i]) continue;
                    missing = true;
                    break;
                }
                if (missing) {
                    this.addMissing();
                    break;
                }
                this.addValue(c, cv, DataType.Numeric);
                break;
            }
            case STRING: {
                boolean missing = false;
                for (int i = 0; i < this.missingValueStrings.length; ++i) {
                    if (cv.getStringValue() != null && !cv.getStringValue().equals(this.missingValueStrings[i])) continue;
                    missing = true;
                    break;
                }
                if (missing) {
                    this.addMissing();
                    break;
                }
                this.addValue(c, cv, DataType.String);
                break;
            }
            case FORMULA: {
                String msg = "Formula detected in already evaluated cell " + CellUtils.formatAsString(c) + "!";
                this.cellError(msg);
                break;
            }
            case ERROR: {
                String msg = "Error detected in cell " + CellUtils.formatAsString(c) + " - " + CellUtils.getErrorMessage(cv.getErrorValue());
                this.cellError(msg);
                break;
            }
            default: {
                String msg = "Unexpected cell type detected for cell " + CellUtils.formatAsString(c) + "!";
                this.cellError(msg);
            }
        }
    }
}

