/*
 * Decompiled with CFR 0.152.
 */
package com.miraisolutions.xlconnect;

import com.miraisolutions.xlconnect.CellStyle;
import com.miraisolutions.xlconnect.Common;
import com.miraisolutions.xlconnect.DataFormatOnlyCellStyle;
import com.miraisolutions.xlconnect.ErrorBehavior;
import com.miraisolutions.xlconnect.HCellStyle;
import com.miraisolutions.xlconnect.SSCellStyle;
import com.miraisolutions.xlconnect.StyleAction;
import com.miraisolutions.xlconnect.XCellStyle;
import com.miraisolutions.xlconnect.data.ColumnBuilder;
import com.miraisolutions.xlconnect.data.DataFrame;
import com.miraisolutions.xlconnect.data.DataType;
import com.miraisolutions.xlconnect.utils.CellUtils;
import com.miraisolutions.xlconnect.utils.DateTimeFormatter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.AreaReference;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellStyle;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellStyles;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTXf;

public final class Workbook
extends Common {
    public static final DateTimeFormatter dateTimeFormatter = new DateTimeFormatter();
    private final org.apache.poi.ss.usermodel.Workbook workbook;
    private File excelFile;
    private StyleAction styleAction = StyleAction.XLCONNECT;
    private String styleNamePrefix = null;
    private String[] missingValue = new String[]{null};
    private final Map<String, Map<String, CellStyle>> stylesMap = new HashMap<String, Map<String, CellStyle>>(10);
    private final Map<DataType, String> dataFormatMap = new EnumMap<DataType, String>(DataType.class);
    private ErrorBehavior onErrorCell = ErrorBehavior.WARN;

    /*
     * WARNING - void declaration
     */
    private Workbook(InputStream in) throws IOException, InvalidFormatException {
        void var1_1;
        this.workbook = WorkbookFactory.create((InputStream)var1_1);
        this.excelFile = null;
        this.initDefaultDataFormats();
        this.initDefaultStyles();
    }

    /*
     * WARNING - void declaration
     */
    private Workbook(File excelFile) throws FileNotFoundException, IOException, InvalidFormatException {
        this(new FileInputStream(excelFile));
        void var1_1;
        this.excelFile = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Workbook(File excelFile, SpreadsheetVersion version) {
        void var1_1;
        void var2_2;
        switch (1.$SwitchMap$org$apache$poi$ss$SpreadsheetVersion[var2_2.ordinal()]) {
            case 1: {
                this.workbook = new HSSFWorkbook();
                break;
            }
            case 2: {
                this.workbook = new XSSFWorkbook();
                break;
            }
            default: {
                throw new IllegalArgumentException("Spreadsheet version not supported!");
            }
        }
        this.excelFile = var1_1;
        this.initDefaultDataFormats();
        this.initDefaultStyles();
    }

    /*
     * WARNING - void declaration
     */
    private void initDefaultStyles() {
        void var1_1;
        void var3_3;
        void var2_2;
        CellStyle dateStyle;
        CellStyle style;
        HashMap<String, Object> xlconnectDefaults = new HashMap<String, Object>(5);
        CellStyle headerStyle = this.getCellStyle("XLConnect.Header");
        if (headerStyle == null) {
            headerStyle = this.createCellStyle("XLConnect.Header");
            headerStyle.setDataFormat(this.dataFormatMap.get((Object)DataType.String));
            headerStyle.setFillPattern((short)1);
            headerStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
            headerStyle.setWrapText(true);
        }
        if ((style = this.getCellStyle("XLConnect.General")) == null) {
            style = this.createCellStyle("XLConnect.General");
            style.setDataFormat(this.dataFormatMap.get((Object)DataType.String));
            style.setWrapText(true);
        }
        if ((dateStyle = this.getCellStyle("XLConnect.Date")) == null) {
            dateStyle = this.createCellStyle("XLConnect.Date");
            dateStyle.setDataFormat(this.dataFormatMap.get((Object)DataType.DateTime));
            dateStyle.setWrapText(true);
        }
        xlconnectDefaults.put("Header", var2_2);
        xlconnectDefaults.put("String", style);
        xlconnectDefaults.put("Numeric", style);
        xlconnectDefaults.put("Boolean", var3_3);
        xlconnectDefaults.put("DateTime", dateStyle);
        this.stylesMap.put("XLCONNECT_STYLE", (Map<String, CellStyle>)var1_1);
    }

    private void initDefaultDataFormats() {
        this.dataFormatMap.put(DataType.Boolean, "General");
        this.dataFormatMap.put(DataType.DateTime, "mm/dd/yyyy hh:mm:ss");
        this.dataFormatMap.put(DataType.Numeric, "General");
        this.dataFormatMap.put(DataType.String, "General");
    }

    /*
     * WARNING - void declaration
     */
    public final void setDataFormat(DataType type, String format) {
        void var2_2;
        void var1_1;
        this.dataFormatMap.put((DataType)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void setStyleAction(StyleAction styleAction) {
        void var1_1;
        this.styleAction = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setStyleNamePrefix(String styleNamePrefix) {
        void var1_1;
        this.styleNamePrefix = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final String[] getSheets() {
        void var2_2;
        int count = this.workbook.getNumberOfSheets();
        String[] sheetNames = new String[count];
        for (int i = 0; i < count; ++i) {
            sheetNames[i] = this.workbook.getSheetName(i);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final int getSheetPos(String sheetName) {
        void var1_1;
        return this.workbook.getSheetIndex((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setSheetPos(String sheetName, int pos) {
        void var2_2;
        void var1_1;
        this.workbook.setSheetOrder((String)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final String[] getDefinedNames(boolean validOnly) {
        void var3_3;
        int count = this.workbook.getNumberOfNames();
        ArrayList<String> nameNames = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            Name namedRegion = this.workbook.getNameAt(i);
            if (validOnly && !Workbook.isValidReference(namedRegion.getRefersToFormula())) continue;
            nameNames.add(namedRegion.getNameName());
        }
        return nameNames.toArray(new String[var3_3.size()]);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean existsSheet(String name) {
        void var1_1;
        return this.workbook.getSheet((String)var1_1) != null;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean existsName(String name) {
        void var1_1;
        return this.workbook.getName((String)var1_1) != null;
    }

    /*
     * WARNING - void declaration
     */
    public final void createSheet(String name) {
        if (name.length() > 31) {
            throw new IllegalArgumentException("Sheet names are not allowed to contain more than 31 characters!");
        }
        if (this.workbook.getSheetIndex(name) < 0) {
            void var1_1;
            this.workbook.createSheet((String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void removeSheet(int sheetIndex) {
        if (sheetIndex >= 0 && sheetIndex < this.workbook.getNumberOfSheets()) {
            void var1_1;
            this.setAlternativeActiveSheet(sheetIndex);
            this.workbook.removeSheetAt((int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void removeSheet(String name) {
        void var1_1;
        this.removeSheet(this.workbook.getSheetIndex((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final void renameSheet(int sheetIndex, String newName) {
        void var2_2;
        void var1_1;
        this.renameSheet(this.workbook.getSheetName((int)var1_1), (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void renameSheet(String name, String newName) {
        void var2_2;
        void var1_1;
        this.workbook.setSheetName(this.workbook.getSheetIndex((String)var1_1), (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void cloneSheet(int index, String newName) {
        void var2_2;
        void var1_1;
        this.cloneSheet(this.workbook.getSheetName((int)var1_1), (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void cloneSheet(String name, String newName) {
        void var2_2;
        void var1_1;
        Sheet sheet = this.workbook.cloneSheet(this.workbook.getSheetIndex(name));
        this.workbook.setSheetName(this.workbook.getSheetIndex((Sheet)var1_1), (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void createName(String name, String formula, boolean overwrite) {
        if (this.existsName(name)) {
            if (overwrite) {
                this.removeName(name);
            } else {
                throw new IllegalArgumentException("Specified name '" + name + "' already exists!");
            }
        }
        Name cname = this.workbook.createName();
        try {
            cname.setNameName(name);
            cname.setRefersToFormula(formula);
            return;
        }
        catch (Exception e) {
            void var1_2;
            void var2_3;
            void var3_5;
            String dummyNameName = "XLConnectDummyName";
            var3_5.setNameName(dummyNameName);
            this.removeName((String)var2_3);
            throw new IllegalArgumentException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void removeName(String name) {
        if (this.workbook.getName(name) != null) {
            void var1_1;
            this.workbook.removeName((String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final String getReferenceFormula(String name) {
        void var1_1;
        return this.getName((String)var1_1).getRefersToFormula();
    }

    /*
     * WARNING - void declaration
     */
    public final int[] getReferenceCoordinates(String name) {
        void var1_2;
        void var2_4;
        void var3_5;
        Name cname = this.getName(name);
        AreaReference aref = new AreaReference(cname.getRefersToFormula());
        CellReference first = aref.getFirstCell();
        CellReference last = aref.getLastCell();
        int top = first.getRow();
        int bottom = last.getRow();
        short left = first.getCol();
        short right = last.getCol();
        return new int[]{var3_5, var2_4, bottom, var1_2};
    }

    /*
     * WARNING - void declaration
     */
    private void writeData(DataFrame data, Sheet sheet, int startRow, int startCol, boolean header) {
        int i;
        int n;
        int n2 = 0;
        Object object = sheet;
        DataFrame dataFrame = data;
        Object object2 = this;
        HashMap hashMap = new HashMap(dataFrame.columns());
        switch (((Workbook)object2).styleAction) {
            case XLCONNECT: {
                int n3;
                object2 = ((Workbook)object2).stylesMap.get("XLCONNECT_STYLE");
                if (dataFrame.hasColumnHeader()) {
                    for (n3 = 0; n3 < dataFrame.columns(); ++n3) {
                        hashMap.put("Header" + n3, object2.get("Header"));
                    }
                }
                block20: for (n3 = 0; n3 < dataFrame.columns(); ++n3) {
                    switch (dataFrame.getColumnType(n3)) {
                        case Boolean: {
                            hashMap.put("Column" + n3, object2.get("Boolean"));
                            continue block20;
                        }
                        case DateTime: {
                            hashMap.put("Column" + n3, object2.get("DateTime"));
                            continue block20;
                        }
                        case Numeric: {
                            hashMap.put("Column" + n3, object2.get("Numeric"));
                            continue block20;
                        }
                        case String: {
                            hashMap.put("Column" + n3, object2.get("String"));
                            continue block20;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown column type detected!");
                        }
                    }
                }
                break;
            }
            case NONE: {
                break;
            }
            case PREDEFINED: {
                int n3;
                if (dataFrame.hasColumnHeader()) {
                    for (n3 = 0; n3 < dataFrame.columns(); ++n3) {
                        n = startCol + n3;
                        hashMap.put("Header" + n3, super.getCellStyle(Workbook.getCell(object, startRow, n, true)));
                    }
                }
                n3 = startRow + (dataFrame.hasColumnHeader() ? 1 : 0);
                for (n2 = 0; n2 < dataFrame.columns(); ++n2) {
                    n = startCol + n2;
                    int n4 = n3;
                    Cell cell = Workbook.getCell(object, n4, n, true);
                    hashMap.put("Column" + n2, super.getCellStyle(cell));
                }
                break;
            }
            case STYLE_NAME_PREFIX: {
                String string;
                if (dataFrame.hasColumnHeader()) {
                    for (n2 = 0; n2 < dataFrame.columns(); ++n2) {
                        string = ((Workbook)object2).styleNamePrefix + ".Header";
                        object = ((Workbook)object2).getCellStyle(string + "." + dataFrame.getColumnName(n2));
                        if (object == null) {
                            object = ((Workbook)object2).getCellStyle(string + "." + (n2 + 1));
                        }
                        if (object == null) {
                            object = ((Workbook)object2).getCellStyle(string);
                        }
                        if (object == null) {
                            object = new SSCellStyle(((Workbook)object2).workbook, ((Workbook)object2).workbook.getCellStyleAt((short)0));
                        }
                        hashMap.put("Header" + n2, object);
                    }
                }
                for (n2 = 0; n2 < dataFrame.columns(); ++n2) {
                    string = ((Workbook)object2).styleNamePrefix + ".Column";
                    object = ((Workbook)object2).getCellStyle(string + "." + dataFrame.getColumnName(n2));
                    if (object == null) {
                        object = ((Workbook)object2).getCellStyle(string + "." + (n2 + 1));
                    }
                    if (object == null) {
                        object = ((Workbook)object2).getCellStyle(string + "." + dataFrame.getColumnType(n2).toString());
                    }
                    if (object == null) {
                        object = new SSCellStyle(((Workbook)object2).workbook, ((Workbook)object2).workbook.getCellStyleAt((short)0));
                    }
                    hashMap.put("Column" + n2, object);
                }
                break;
            }
            case DATA_FORMAT_ONLY: {
                int n5;
                DataFormatOnlyCellStyle dataFormatOnlyCellStyle = DataFormatOnlyCellStyle.get();
                if (dataFrame.hasColumnHeader()) {
                    for (n5 = 0; n5 < dataFrame.columns(); ++n5) {
                        hashMap.put("Header" + n5, dataFormatOnlyCellStyle);
                    }
                }
                for (n5 = 0; n5 < dataFrame.columns(); ++n5) {
                    hashMap.put("Column" + n5, dataFormatOnlyCellStyle);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Style action not supported!");
            }
        }
        HashMap styles = hashMap;
        int rowIndex = startRow;
        int colIndex = startCol;
        if (header && data.hasColumnHeader()) {
            for (i = 0; i < data.columns(); ++i) {
                n = startCol + i;
                Cell cell = Workbook.getCell(sheet, startRow, n, true);
                cell.setCellValue(data.getColumnName(i));
                cell.setCellType(1);
                this.setCellStyle(cell, (CellStyle)styles.get("Header" + i));
            }
            ++rowIndex;
        }
        for (i = 0; i < data.columns(); ++i) {
            CellStyle cs = (CellStyle)styles.get("Column" + i);
            switch (data.getColumnType(i)) {
                case Numeric: {
                    int n6;
                    ArrayList numericValues = data.getColumn(i);
                    for (int j = 0; j < data.rows(); ++j) {
                        n = colIndex;
                        n6 = rowIndex + j;
                        Cell cell = Workbook.getCell(sheet, n6, n, true);
                        Double d = (Double)numericValues.get(j);
                        if (d == null) {
                            this.setMissing(cell);
                            continue;
                        }
                        cell.setCellValue(d.doubleValue());
                        cell.setCellType(0);
                        this.setCellStyle(cell, cs);
                    }
                    break;
                }
                case String: {
                    int n6;
                    ArrayList stringValues = data.getColumn(i);
                    for (int j = 0; j < data.rows(); ++j) {
                        n = colIndex;
                        n6 = rowIndex + j;
                        Cell cell = Workbook.getCell(sheet, n6, n, true);
                        if ((String)stringValues.get(j) == null) {
                            this.setMissing(cell);
                            continue;
                        }
                        cell.setCellValue((String)stringValues.get(j));
                        cell.setCellType(1);
                        this.setCellStyle(cell, cs);
                    }
                    break;
                }
                case Boolean: {
                    int n6;
                    ArrayList booleanValues = data.getColumn(i);
                    for (int j = 0; j < data.rows(); ++j) {
                        n = colIndex;
                        n6 = rowIndex + j;
                        Cell cell = Workbook.getCell(sheet, n6, n, true);
                        if ((Boolean)booleanValues.get(j) == null) {
                            this.setMissing(cell);
                            continue;
                        }
                        cell.setCellValue(((Boolean)booleanValues.get(j)).booleanValue());
                        cell.setCellType(4);
                        this.setCellStyle(cell, cs);
                    }
                    break;
                }
                case DateTime: {
                    int n6;
                    ArrayList dateValues = data.getColumn(i);
                    for (int j = 0; j < data.rows(); ++j) {
                        n = colIndex;
                        n6 = rowIndex + j;
                        Cell cell = Workbook.getCell(sheet, n6, n, true);
                        Date d = (Date)dateValues.get(j);
                        if (d == null) {
                            this.setMissing(cell);
                            continue;
                        }
                        cell.setCellValue(d);
                        cell.setCellType(0);
                        this.setCellStyle(cell, cs);
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown column type detected!");
                }
            }
            ++colIndex;
        }
        if (this.workbook instanceof HSSFWorkbook) {
            void var2_2;
            ((HSSFSheet)var2_2).setForceFormulaRecalculation(true);
        }
    }

    private DataFrame readData(Sheet sheet, int startRow, int startCol, int nrows, int ncols, boolean header, DataType[] colTypes, boolean forceConversion, String dateTimeFormat) {
        DataFrame data = new DataFrame();
        FormulaEvaluator evaluator = this.workbook.getCreationHelper().createFormulaEvaluator();
        evaluator.clearAllCachedResultValues();
        for (int col = 0; col < ncols; ++col) {
            int row;
            CellValue cv;
            Cell cell;
            int colIndex = startCol + col;
            String columnHeader = null;
            if (header && (cell = Workbook.getCell(sheet, startRow, colIndex, false)) != null && (cv = evaluator.evaluate(cell)) != null) {
                columnHeader = cv.getStringValue();
            }
            if (columnHeader == null) {
                columnHeader = "Col" + col;
            }
            ColumnBuilder cb = new ColumnBuilder(nrows, forceConversion);
            cb.setDateTimeFormat(dateTimeFormat);
            int n = row = header ? 1 : 0;
            while (row < nrows) {
                block24: {
                    int rowIndex = startRow + row;
                    Cell cell2 = Workbook.getCell(sheet, rowIndex, colIndex, false);
                    if (cell2 == null) {
                        cb.addMissing();
                    } else if (cell2.getCellType() == 5 || cell2.getCellType() == 2 && cell2.getCachedFormulaResultType() == 5) {
                        String msg = "Error detected in cell " + CellUtils.formatAsString(cell2) + " - " + CellUtils.getErrorMessage(cell2.getErrorCellValue());
                        this.cellError(cb, msg);
                    } else {
                        CellValue cv2;
                        try {
                            cv2 = evaluator.evaluate(cell2);
                        }
                        catch (Exception e) {
                            String msg = "Error when trying to evaluate cell " + CellUtils.formatAsString(cell2) + " - " + e.getMessage();
                            this.cellError(cb, msg);
                            break block24;
                        }
                        if (cv2 == null) {
                            cb.addMissing();
                        } else {
                            switch (cv2.getCellType()) {
                                case 3: {
                                    cb.addMissing();
                                    break;
                                }
                                case 4: {
                                    cb.addValue(cell2, cv2, DataType.Boolean);
                                    break;
                                }
                                case 0: {
                                    if (DateUtil.isCellDateFormatted((Cell)cell2)) {
                                        cb.addValue(cell2, cv2, DataType.DateTime);
                                        break;
                                    }
                                    cb.addValue(cell2, cv2, DataType.Numeric);
                                    break;
                                }
                                case 1: {
                                    boolean missing = false;
                                    for (int i = 0; i < this.missingValue.length; ++i) {
                                        if (cv2.getStringValue() != null && !cv2.getStringValue().equals(this.missingValue[i])) continue;
                                        missing = true;
                                        break;
                                    }
                                    if (missing) {
                                        cb.addMissing();
                                        break;
                                    }
                                    cb.addValue(cell2, cv2, DataType.String);
                                    break;
                                }
                                case 2: {
                                    String i = "Formula detected in already evaluated cell " + CellUtils.formatAsString(cell2) + "!";
                                    this.cellError(cb, i);
                                    break;
                                }
                                case 5: {
                                    String i = "Error detected in cell " + CellUtils.formatAsString(cell2) + " - " + CellUtils.getErrorMessage(cv2.getErrorValue());
                                    this.cellError(cb, i);
                                    break;
                                }
                                default: {
                                    String i = "Unexpected cell type detected for cell " + CellUtils.formatAsString(cell2) + "!";
                                    this.cellError(cb, i);
                                }
                            }
                        }
                    }
                }
                ++row;
            }
            DataType columnType = colTypes != null && colTypes.length > 0 ? colTypes[col % colTypes.length] : cb.determineColumnType();
            ArrayList columnValues = cb.build(columnType);
            data.addColumn(columnHeader, columnType, columnValues);
            for (String w : cb.retrieveWarnings()) {
                this.addWarning(w);
            }
        }
        return data;
    }

    /*
     * WARNING - void declaration
     */
    private void cellError(ColumnBuilder cb, String msg) {
        void var2_2;
        if (this.onErrorCell.equals((Object)ErrorBehavior.WARN)) {
            void var1_1;
            var1_1.addMissing();
            this.addWarning(msg);
            return;
        }
        throw new IllegalArgumentException((String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void onErrorCell(ErrorBehavior eb) {
        void var1_1;
        this.onErrorCell = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void writeNamedRegion(DataFrame data, String name, boolean header) {
        void var3_3;
        void var1_1;
        void var2_2;
        Name cname = this.getName(name);
        this.checkName(cname);
        Sheet sheet = this.workbook.getSheet(cname.getSheetName());
        CellReference topLeft = new AreaReference(cname.getRefersToFormula()).getFirstCell();
        int bottomRightRow = topLeft.getRow() + data.rows() - 1;
        if (header) {
            ++bottomRightRow;
        }
        int bottomRightCol = topLeft.getCol() + data.columns() - 1;
        CellReference bottomRight = new CellReference(sheet.getSheetName(), bottomRightRow, bottomRightCol, true, true);
        AreaReference aref = new AreaReference(topLeft, bottomRight);
        var2_2.setRefersToFormula(aref.formatAsString());
        this.writeData((DataFrame)var1_1, sheet, topLeft.getRow(), topLeft.getCol(), (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final DataFrame readNamedRegion(String name, boolean header, DataType[] colTypes, boolean forceConversion, String dateTimeFormat) {
        void var3_4;
        void var2_3;
        void var1_2;
        Name cname = this.getName(name);
        this.checkName(cname);
        Sheet sheet = this.workbook.getSheet(cname.getSheetName());
        AreaReference aref = new AreaReference(cname.getRefersToFormula());
        CellReference topLeft = aref.getFirstCell();
        CellReference bottomRight = aref.getLastCell();
        int nrows = bottomRight.getRow() - topLeft.getRow() + 1;
        int ncols = bottomRight.getCol() - topLeft.getCol() + 1;
        return this.readData(sheet, topLeft.getRow(), topLeft.getCol(), nrows, (int)var1_2, (boolean)var2_3, (DataType[])var3_4, forceConversion, dateTimeFormat);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeWorksheet(DataFrame data, int worksheetIndex, int startRow, int startCol, boolean header) {
        void var3_4;
        void var2_3;
        void var1_1;
        Sheet sheet = this.workbook.getSheetAt(worksheetIndex);
        this.writeData((DataFrame)var1_1, (Sheet)var2_3, (int)var3_4, startCol, header);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeWorksheet(DataFrame data, String worksheetName, int startRow, int startCol, boolean header) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.writeWorksheet((DataFrame)var1_1, this.workbook.getSheetIndex((String)var2_2), (int)var3_3, startCol, header);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeWorksheet(DataFrame data, int worksheetIndex, boolean header) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.writeWorksheet((DataFrame)var1_1, (int)var2_2, 0, 0, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeWorksheet(DataFrame data, String worksheetName, boolean header) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.writeWorksheet((DataFrame)var1_1, (String)var2_2, 0, 0, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final DataFrame readWorksheet(int worksheetIndex, int startRow, int startCol, int endRow, int endCol, boolean header, DataType[] colTypes, boolean forceConversion, String dateTimeFormat) {
        void var3_3;
        void var2_2;
        Row r;
        int i;
        Sheet sheet = this.workbook.getSheetAt(worksheetIndex);
        if (startRow < 0) {
            startRow = sheet.getFirstRowNum();
        }
        if (startRow < 0) {
            throw new IllegalArgumentException("Start row cannot be determined!");
        }
        if (sheet.getRow(startRow) == null) {
            throw new IllegalArgumentException("Specified sheet (index = " + (worksheetIndex + 1) + ", name = " + this.workbook.getSheetName(worksheetIndex) + ") does not contain any data!");
        }
        if (endRow < 0) {
            endRow = sheet.getLastRowNum();
        }
        if (startCol < 0) {
            startCol = sheet.getRow(startRow).getFirstCellNum();
            for (i = startRow; i <= endRow; ++i) {
                r = sheet.getRow(i);
                if (r == null || r.getFirstCellNum() >= startCol) continue;
                startCol = r.getFirstCellNum();
            }
        }
        if (startCol < 0) {
            throw new IllegalArgumentException("Start column cannot be determined!");
        }
        if (endCol < 0) {
            endCol = startCol;
            for (i = startRow; i <= endRow; ++i) {
                r = sheet.getRow(i);
                if (r == null || r.getLastCellNum() - 1 <= endCol) continue;
                endCol = r.getLastCellNum() - 1;
            }
        }
        return this.readData(sheet, startRow, startCol, endRow - var2_2 + 1, endCol - var3_3 + 1, header, colTypes, forceConversion, dateTimeFormat);
    }

    /*
     * WARNING - void declaration
     */
    public final DataFrame readWorksheet(String worksheetName, int startRow, int startCol, int endRow, int endCol, boolean header, DataType[] colTypes, boolean forceConversion, String dateTimeFormat) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.readWorksheet(this.workbook.getSheetIndex((String)var1_1), (int)var2_2, (int)var3_3, endRow, endCol, header, colTypes, forceConversion, dateTimeFormat);
    }

    /*
     * Unable to fully structure code
     */
    public final void addImage(String filename, String name, boolean originalSize) throws FileNotFoundException, IOException {
        block16: {
            block15: {
                var4_5 = var3_3;
                var3_4 = var2_2;
                var2_2 = new File((String)var1_1);
                var1_1 = this;
                var3_4 = var1_1.getName((String)var3_4);
                var5_6 = var1_1.workbook.getSheet(var3_4.getSheetName());
                var3_4 = new AreaReference(var3_4.getRefersToFormula());
                var6_7 = var3_4.getFirstCell();
                var3_4 = var3_4.getLastCell();
                var7_8 = var2_2.getName().toLowerCase();
                if (var7_8.endsWith("jpg") || var7_8.endsWith("jpeg")) {
                    var7_9 = 5;
                } else if (var7_8.endsWith("png")) {
                    var7_9 = 6;
                } else if (var7_8.endsWith("wmf")) {
                    var7_9 = 3;
                } else if (var7_8.endsWith("emf")) {
                    var7_9 = 2;
                } else if (var7_8.endsWith("bmp") || var7_8.endsWith("dib")) {
                    var7_9 = 7;
                } else if (var7_8.endsWith("pict") || var7_8.endsWith("pct") || var7_8.endsWith("pic")) {
                    var7_9 = 4;
                } else {
                    throw new IllegalArgumentException("Image type \"" + var7_8.substring(var7_8.lastIndexOf(46) + 1) + "\" not supported!");
                }
                var2_2 = new FileInputStream((File)var2_2);
                var8_10 = IOUtils.toByteArray((InputStream)var2_2);
                var7_9 = var1_1.workbook.addPicture(var8_10, var7_9);
                var2_2.close();
                if (!(var1_1.workbook instanceof HSSFWorkbook)) break block15;
                var2_2 = ((HSSFSheet)var5_6).getDrawingPatriarch();
                if (var2_2 != null) break block16;
                ** GOTO lbl-1000
            }
            if (var1_1.workbook instanceof XSSFWorkbook) {
                var2_2 = ((XSSFSheet)var5_6).createDrawingPatriarch();
            } else lbl-1000:
            // 2 sources

            {
                var2_2 = var5_6.createDrawingPatriarch();
            }
        }
        var1_1 = var1_1.workbook.getCreationHelper().createClientAnchor();
        var1_1.setRow1(var6_7.getRow());
        var1_1.setCol1(var6_7.getCol());
        var1_1.setRow2(var3_4.getRow() + 1);
        var1_1.setCol2(var3_4.getCol() + 1);
        var1_1.setAnchorType(3);
        var1_1 = var2_2.createPicture((ClientAnchor)var1_1, var7_9);
        if (var4_5 != false) {
            var1_1.resize();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final CellStyle createCellStyle(String name) {
        void var1_1;
        if (this.getCellStyle(name) == null) {
            if (this.workbook instanceof HSSFWorkbook) {
                String string = name;
                name = (HSSFWorkbook)this.workbook;
                HSSFCellStyle hSSFCellStyle = name.createCellStyle();
                if (string != null) {
                    hSSFCellStyle.setUserStyleName(string);
                }
                return new HCellStyle((HSSFWorkbook)name, hSSFCellStyle);
            }
            if (this.workbook instanceof XSSFWorkbook) {
                String string = name;
                name = (XSSFWorkbook)this.workbook;
                int n = 0;
                CTXf cTXf = CTXf.Factory.newInstance();
                cTXf.setNumFmtId(0L);
                cTXf.setFontId(0L);
                cTXf.setFillId(0L);
                cTXf.setBorderId(0L);
                if (string != null) {
                    CTCellStyles cTCellStyles = name.getStylesSource().getCTStylesheet().getCellStyles();
                    if (cTCellStyles == null) {
                        cTCellStyles = name.getStylesSource().getCTStylesheet().addNewCellStyles();
                        cTCellStyles.setCount(0L);
                    }
                    if (cTCellStyles.getCount() == 0L) {
                        CTCellStyle cTCellStyle = cTCellStyles.addNewCellStyle();
                        cTCellStyle.setName("Standard");
                        cTCellStyle.setXfId(0L);
                        cTCellStyle.setBuiltinId(0L);
                        cTCellStyles.setCount(1L);
                    }
                    CTXf cTXf2 = CTXf.Factory.newInstance();
                    cTXf2.setNumFmtId(0L);
                    cTXf2.setFontId(0L);
                    cTXf2.setFillId(0L);
                    cTXf2.setBorderId(0L);
                    n = name.getStylesSource().putCellStyleXf(cTXf2);
                    cTXf.setXfId((long)(n - 1));
                    CTCellStyle cTCellStyle = cTCellStyles.addNewCellStyle();
                    cTCellStyle.setName(string);
                    cTCellStyle.setXfId((long)(n - 1));
                    cTCellStyles.setCount(cTCellStyles.getCount() + 1L);
                }
                int n2 = name.getStylesSource().putCellXf(cTXf);
                return new XCellStyle((XSSFWorkbook)name, n2 - 1, n - 1);
            }
            return null;
        }
        throw new IllegalArgumentException("Cell style with name '" + (String)var1_1 + "' already exists!");
    }

    public final CellStyle createCellStyle() {
        return this.createCellStyle(null);
    }

    public final int getActiveSheetIndex() {
        if (this.workbook.getNumberOfSheets() <= 0) {
            return -1;
        }
        return this.workbook.getActiveSheetIndex();
    }

    public final String getActiveSheetName() {
        if (this.workbook.getNumberOfSheets() <= 0) {
            return null;
        }
        return this.workbook.getSheetName(this.workbook.getActiveSheetIndex());
    }

    /*
     * WARNING - void declaration
     */
    public final void setActiveSheet(int sheetIndex) {
        void var1_1;
        this.workbook.setActiveSheet((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setActiveSheet(String sheetName) {
        void var1_2;
        int sheetIndex = this.workbook.getSheetIndex(sheetName);
        this.setActiveSheet((int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void hideSheet(int sheetIndex, boolean veryHidden) {
        void var2_2;
        void var1_1;
        this.setAlternativeActiveSheet(sheetIndex);
        this.workbook.setSheetHidden((int)var1_1, var2_2 != false ? 2 : 1);
    }

    /*
     * WARNING - void declaration
     */
    public final void hideSheet(String sheetName, boolean veryHidden) {
        void var2_2;
        void var1_1;
        this.hideSheet(this.workbook.getSheetIndex((String)var1_1), (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void unhideSheet(int sheetIndex) {
        void var1_1;
        this.workbook.setSheetHidden((int)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public final void unhideSheet(String sheetName) {
        void var1_1;
        this.unhideSheet(this.workbook.getSheetIndex((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isSheetHidden(int sheetIndex) {
        void var1_1;
        return this.workbook.isSheetHidden((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isSheetHidden(String sheetName) {
        void var1_1;
        return this.isSheetHidden(this.workbook.getSheetIndex((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isSheetVeryHidden(int sheetIndex) {
        void var1_1;
        return this.workbook.isSheetVeryHidden((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isSheetVeryHidden(String sheetName) {
        void var1_1;
        return this.isSheetVeryHidden(this.workbook.getSheetIndex((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final void setColumnWidth(int sheetIndex, int columnIndex, int width) {
        void var1_2;
        void var2_3;
        void var3_4;
        Sheet sheet = this.getSheet(sheetIndex);
        if (width >= 0) {
            sheet.setColumnWidth(columnIndex, width);
            return;
        }
        if (var3_4 == -1) {
            sheet.autoSizeColumn(columnIndex);
            return;
        }
        sheet.setColumnWidth((int)var2_3, var1_2.getDefaultColumnWidth() << 8);
    }

    /*
     * WARNING - void declaration
     */
    public final void setColumnWidth(String sheetName, int columnIndex, int width) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.setColumnWidth(this.workbook.getSheetIndex((String)var1_1), (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final void setRowHeight(int sheetIndex, int rowIndex, float height) {
        Sheet sheet = this.getSheet(sheetIndex);
        Row r = sheet.getRow(rowIndex);
        if (r == null) {
            void var2_2;
            void var1_1;
            r = this.getSheet((int)var1_1).createRow((int)var2_2);
        }
        if (height >= 0.0f) {
            void var3_3;
            r.setHeightInPoints((float)var3_3);
            return;
        }
        r.setHeightInPoints(sheet.getDefaultRowHeightInPoints());
    }

    /*
     * WARNING - void declaration
     */
    public final void setRowHeight(String sheetName, int rowIndex, float height) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.setRowHeight(this.workbook.getSheetIndex((String)var1_1), (int)var2_2, (float)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void save(File f) throws FileNotFoundException, IOException {
        void var1_1;
        this.excelFile = f;
        FileOutputStream fos = new FileOutputStream(f, false);
        this.workbook.write((OutputStream)fos);
        var1_1.close();
    }

    /*
     * WARNING - void declaration
     */
    public final void save(String file) throws FileNotFoundException, IOException {
        void var1_1;
        this.save(new File((String)var1_1));
    }

    public final void save() throws FileNotFoundException, IOException {
        this.save(this.excelFile);
    }

    /*
     * WARNING - void declaration
     */
    private Name getName(String name) {
        void var1_1;
        Name cname = this.workbook.getName(name);
        if (cname != null) {
            void var2_2;
            return var2_2;
        }
        throw new IllegalArgumentException("Name '" + (String)var1_1 + "' does not exist!");
    }

    private static boolean isValidReference(String reference) {
        String string;
        return reference != null && !reference.startsWith("#REF!") && !string.startsWith("#NULL!");
    }

    /*
     * WARNING - void declaration
     */
    private void checkName(Name name) {
        if (!Workbook.isValidReference(name.getRefersToFormula())) {
            throw new IllegalArgumentException("Name '" + name.getNameName() + "' has invalid reference!");
        }
        if (!this.existsSheet(name.getSheetName())) {
            void var1_1;
            throw new IllegalArgumentException("Name '" + var1_1.getNameName() + "' does not refer to a valid sheet!");
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Cell getCell(Sheet sheet, int rowIndex, int colIndex, boolean create) {
        Sheet sheet2;
        Sheet cell;
        Row row = sheet.getRow(rowIndex);
        if (row == null) {
            if (create) {
                void var1_1;
                row = sheet.createRow((int)var1_1);
            } else {
                return null;
            }
        }
        if ((cell = row.getCell(colIndex)) == null) {
            void var3_3;
            if (var3_3 != false) {
                void var2_2;
                cell = row.createCell((int)var2_2);
            } else {
                return null;
            }
        }
        return sheet2;
    }

    /*
     * WARNING - void declaration
     */
    private Sheet getSheet(int sheetIndex) {
        void var1_1;
        if (sheetIndex < 0 || sheetIndex >= this.workbook.getNumberOfSheets()) {
            throw new IllegalArgumentException("Sheet with index " + sheetIndex + " does not exist!");
        }
        return this.workbook.getSheetAt((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private Sheet getSheet(String sheetName) {
        void var2_2;
        Sheet sheet = this.workbook.getSheet(sheetName);
        if (sheet == null) {
            void var1_1;
            throw new IllegalArgumentException("Sheet with name '" + (String)var1_1 + "' does not exist!");
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final void setMissingValue(String[] values) {
        void var1_1;
        this.missingValue = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void setMissing(Cell cell) {
        void var1_1;
        if (this.missingValue.length <= 0 || this.missingValue[0] == null) {
            cell.setCellType(3);
            return;
        }
        cell.setCellValue(this.missingValue[0]);
        cell.setCellType(1);
        this.setCellStyle((Cell)var1_1, DataFormatOnlyCellStyle.get());
    }

    /*
     * WARNING - void declaration
     */
    private void setAlternativeActiveSheet(int sheetIndex) {
        if (sheetIndex == this.getActiveSheetIndex()) {
            void var2_2;
            boolean ok = false;
            for (int i = 0; i < this.workbook.getNumberOfSheets(); ++i) {
                if (i == sheetIndex || this.workbook.isSheetHidden(i) || this.workbook.isSheetVeryHidden(i)) continue;
                this.setActiveSheet(i);
                ok = true;
                break;
            }
            if (var2_2 == false) {
                throw new IllegalArgumentException("Cannot hide or remove sheet as there would be no alternative active sheet left!");
            }
        }
    }

    public final CellStyle getCellStyle(String name) {
        if (this.workbook instanceof HSSFWorkbook) {
            String string = name;
            name = (HSSFWorkbook)this.workbook;
            HSSFWorkbook hSSFWorkbook = name;
            for (short s = 0; s < name.getNumCellStyles(); s = (short)(s + 1)) {
                HSSFCellStyle hSSFCellStyle = hSSFWorkbook.getCellStyleAt(s);
                if (hSSFCellStyle.getUserStyleName() == null || !hSSFCellStyle.getUserStyleName().equals(string)) continue;
                return new HCellStyle((HSSFWorkbook)name, hSSFCellStyle);
            }
            return null;
        }
        if (this.workbook instanceof XSSFWorkbook) {
            XSSFWorkbook xSSFWorkbook;
            void var2_3 = xSSFWorkbook;
            xSSFWorkbook = (XSSFWorkbook)this.workbook;
            CTCellStyles cTCellStyles = xSSFWorkbook.getStylesSource().getCTStylesheet().getCellStyles();
            if (cTCellStyles != null) {
                int n = 0;
                while ((long)n < cTCellStyles.getCount()) {
                    CTCellStyle cTCellStyle = cTCellStyles.getCellStyleArray(n);
                    if (cTCellStyle.getName().equals(var2_3)) {
                        int n2 = (int)cTCellStyle.getXfId();
                        return new XCellStyle(xSSFWorkbook, -1, n2);
                    }
                    ++n;
                }
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private CellStyle getCellStyle(Cell cell) {
        void var1_1;
        return new SSCellStyle(this.workbook, var1_1.getCellStyle());
    }

    /*
     * WARNING - void declaration
     */
    private void setCellStyle(Cell c, CellStyle cs) {
        if (cs != null) {
            void var1_1;
            void var2_2;
            if (cs instanceof HCellStyle) {
                HCellStyle.set((HSSFCell)c, (HCellStyle)cs);
                return;
            }
            if (cs instanceof XCellStyle) {
                XCellStyle.set((XSSFCell)c, (XCellStyle)cs);
                return;
            }
            if (cs instanceof DataFormatOnlyCellStyle) {
                CellStyle csx = this.getCellStyle(c);
                switch (c.getCellType()) {
                    case 0: {
                        if (DateUtil.isCellDateFormatted((Cell)c)) {
                            csx.setDataFormat(this.dataFormatMap.get((Object)DataType.DateTime));
                            break;
                        }
                        csx.setDataFormat(this.dataFormatMap.get((Object)DataType.Numeric));
                        break;
                    }
                    case 1: {
                        csx.setDataFormat(this.dataFormatMap.get((Object)DataType.String));
                        break;
                    }
                    case 4: {
                        csx.setDataFormat(this.dataFormatMap.get((Object)DataType.Boolean));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected cell type detected!");
                    }
                }
                SSCellStyle.set(c, (SSCellStyle)var2_2);
                return;
            }
            SSCellStyle.set((Cell)var1_1, (SSCellStyle)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setCellStyle(int sheetIndex, int row, int col, CellStyle cs) {
        void var1_2;
        void var2_3;
        void var3_4;
        Sheet sheet = this.getSheet(sheetIndex);
        sheetIndex = var3_4;
        var3_4 = var2_3;
        Cell c = Workbook.getCell(sheet, (int)var3_4, sheetIndex, true);
        this.setCellStyle((Cell)var1_2, cs);
    }

    /*
     * WARNING - void declaration
     */
    public final void setCellStyle(String sheetName2, int row, int col, CellStyle cs) {
        void var1_3;
        void var2_4;
        void var3_5;
        void sheetName2 = var3_5;
        var3_5 = var2_4;
        Cell c = Workbook.getCell(this.getSheet(sheetName2), (int)var3_5, (int)sheetName2, true);
        this.setCellStyle((Cell)var1_3, cs);
    }

    /*
     * WARNING - void declaration
     */
    public final void mergeCells(int sheetIndex, String reference) {
        void var2_2;
        void var1_1;
        this.getSheet((int)var1_1).addMergedRegion(CellRangeAddress.valueOf((String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final void mergeCells(String sheetName, String reference) {
        void var2_2;
        void var1_1;
        this.getSheet((String)var1_1).addMergedRegion(CellRangeAddress.valueOf((String)var2_2));
    }

    public final void unmergeCells(int sheetIndex, String reference) {
        Sheet sheet = this.getSheet(sheetIndex);
        for (int i = 0; i < sheet.getNumMergedRegions(); ++i) {
            if (!sheet.getMergedRegion(i).formatAsString().equals(reference)) continue;
            sheet.removeMergedRegion(i);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void unmergeCells(String sheetName, String reference) {
        void var2_2;
        void var1_1;
        this.unmergeCells(this.workbook.getSheetIndex((String)var1_1), (String)var2_2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Workbook getWorkbook(String filename, boolean create) throws FileNotFoundException, IOException, InvalidFormatException {
        void var1_1;
        Object object;
        if (((File)(object = new File((String)object))).exists()) {
            return new Workbook((File)object);
        }
        if (var1_1 == false) throw new FileNotFoundException("File '" + ((File)object).getName() + "' could not be found - you may specify to automatically create the file if not existing.");
        String string = ((File)object).getName().toLowerCase();
        if (string.endsWith(".xls")) {
            return new Workbook((File)object, SpreadsheetVersion.EXCEL97);
        }
        if (!string.endsWith(".xlsx")) throw new IllegalArgumentException("File extension \"" + string.substring(string.lastIndexOf(46) + 1) + "\" not supported! Only *.xls and *.xlsx are allowed!");
        return new Workbook((File)object, SpreadsheetVersion.EXCEL2007);
    }

    /*
     * WARNING - void declaration
     */
    public final void setCellFormula(int sheetIndex, int row, int col, String formula) {
        void var2_2;
        void var3_3;
        void var1_1;
        Sheet sheet = this.getSheet((int)var1_1);
        var1_1 = var3_3;
        var3_3 = var2_2;
        Workbook.getCell(sheet, (int)var3_3, (int)var1_1, true).setCellFormula(formula);
    }

    /*
     * WARNING - void declaration
     */
    public final void setCellFormula(String sheetName, int row, int col, String formula) {
        void var1_1;
        void var2_3;
        void var3_4;
        void var1_2 = var3_4;
        var3_4 = var2_3;
        Workbook.getCell(this.getSheet((String)var1_1), (int)var3_4, (int)var1_2, true).setCellFormula(formula);
    }

    /*
     * WARNING - void declaration
     */
    public final String getCellFormula(int sheetIndex, int row, int col) {
        void var2_2;
        void var3_3;
        void var1_1;
        Sheet sheet = this.getSheet((int)var1_1);
        var1_1 = var3_3;
        var3_3 = var2_2;
        return Workbook.getCell(sheet, (int)var3_3, (int)var1_1, true).getCellFormula();
    }

    /*
     * WARNING - void declaration
     */
    public final String getCellFormula(String sheetName, int row, int col) {
        void var1_1;
        void var2_3;
        void var3_4;
        void var1_2 = var3_4;
        var3_4 = var2_3;
        return Workbook.getCell(this.getSheet((String)var1_1), (int)var3_4, (int)var1_2, true).getCellFormula();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean getForceFormulaRecalculation(int sheetIndex) {
        void var1_1;
        return this.getSheet((int)var1_1).getForceFormulaRecalculation();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean getForceFormulaRecalculation(String sheetName) {
        void var1_1;
        return this.getSheet((String)var1_1).getForceFormulaRecalculation();
    }

    /*
     * WARNING - void declaration
     */
    public final void setForceFormulaRecalculation(int sheetIndex, boolean value) {
        void var2_2;
        void var1_1;
        this.getSheet((int)var1_1).setForceFormulaRecalculation((boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void setForceFormulaRecalculation(String sheetName, boolean value) {
        void var2_2;
        void var1_1;
        this.getSheet((String)var1_1).setForceFormulaRecalculation((boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void setAutoFilter(int sheetIndex, String reference) {
        void var2_2;
        void var1_1;
        this.getSheet((int)var1_1).setAutoFilter(CellRangeAddress.valueOf((String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final void setAutoFilter(String sheetName, String reference) {
        void var2_2;
        void var1_1;
        this.getSheet((String)var1_1).setAutoFilter(CellRangeAddress.valueOf((String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final int getLastRow(int sheetIndex) {
        void var1_1;
        return this.getSheet((int)var1_1).getLastRowNum();
    }

    /*
     * WARNING - void declaration
     */
    public final int getLastRow(String sheetName) {
        void var1_1;
        return this.getSheet((String)var1_1).getLastRowNum();
    }

    /*
     * WARNING - void declaration
     */
    public final void appendNamedRegion(DataFrame data, String name, boolean header) {
        void var1_3;
        void var2_4;
        void var3_5;
        Sheet sheet = this.workbook.getSheet(this.getName(name).getSheetName());
        int[] coord = this.getReferenceCoordinates(name);
        this.writeData(data, sheet, coord[2] + 1, coord[1], header);
        int bottom = coord[2] + data.rows();
        int right = Math.max(coord[1] + data.columns() - 1, coord[3]);
        String formula = new CellRangeAddress(coord[0], (int)var3_5, coord[1], right).formatAsString(sheet.getSheetName(), true);
        this.createName((String)var2_4, (String)var1_3, true);
    }

    /*
     * WARNING - void declaration
     */
    public final void appendWorksheet(DataFrame data, int worksheetIndex, boolean header) {
        void var3_3;
        void var2_2;
        void var1_1;
        int n;
        short s;
        Sheet sheet = this.getSheet(worksheetIndex);
        int lastRow = this.getLastRow(worksheetIndex);
        int n2 = Integer.MAX_VALUE;
        for (int i = 0; i < lastRow && s > 0; ++i) {
            Row row = sheet.getRow(i);
            if (row == null || row.getFirstCellNum() >= s) continue;
            s = row.getFirstCellNum();
        }
        if (s == Integer.MAX_VALUE) {
            n = 0;
        }
        this.writeWorksheet((DataFrame)var1_1, worksheetIndex, this.getLastRow((int)var2_2) + 1, n, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final void appendWorksheet(DataFrame data, String worksheetName, boolean header) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.appendWorksheet((DataFrame)var1_1, this.workbook.getSheetIndex((String)var2_2), (boolean)var3_3);
    }

    public final void clearSheet(int sheetIndex) {
        Sheet sheet = this.getSheet(sheetIndex);
        int firstRow = sheet.getFirstRowNum();
        for (int i = sheet.getLastRowNum(); i >= firstRow; --i) {
            Row r = sheet.getRow(i);
            if (r == null) continue;
            sheet.removeRow(r);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void clearSheet(String sheetName) {
        void var1_1;
        this.clearSheet(this.workbook.getSheetIndex((String)var1_1));
    }

    public final void clearRange(int sheetIndex, int[] coords) {
        Sheet sheet = this.getSheet(sheetIndex);
        for (int i = coords[0]; i <= coords[2]; ++i) {
            Row row = sheet.getRow(i);
            if (row == null) continue;
            for (int j = coords[1]; j <= coords[3]; ++j) {
                Cell cell = row.getCell(j);
                if (cell == null) continue;
                row.removeCell(cell);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void clearRange(String sheetName, int[] coords) {
        void var2_2;
        void var1_1;
        this.clearRange(this.workbook.getSheetIndex((String)var1_1), (int[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void clearRangeFromReference(String reference) {
        void var1_1;
        void var3_3;
        void var2_2;
        AreaReference ref = new AreaReference(reference);
        CellReference firstCell = ref.getFirstCell();
        CellReference lastCell = ref.getLastCell();
        String sheetName = firstCell.getSheetName();
        int[] coords = new int[]{firstCell.getRow(), var2_2.getCol(), lastCell.getRow(), lastCell.getCol()};
        this.clearRange((String)var3_3, (int[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void clearNamedRegion(String name) {
        void var1_1;
        void var2_2;
        String sheetName = this.getName(name).getSheetName();
        int[] coords = this.getReferenceCoordinates(name);
        this.clearRange((String)var2_2, (int[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void createFreezePane(int sheetIndex, int colSplit, int rowSplit, int leftColumn, int topRow) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (leftColumn < 0 | topRow < 0) {
            this.getSheet(sheetIndex).createFreezePane(colSplit, rowSplit);
            return;
        }
        this.getSheet((int)var1_1).createFreezePane((int)var2_2, (int)var3_3, leftColumn, topRow);
    }

    /*
     * WARNING - void declaration
     */
    public final void createFreezePane(String sheetName, int colSplit, int rowSplit, int leftColumn, int topRow) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.createFreezePane(this.workbook.getSheetIndex((String)var1_1), (int)var2_2, (int)var3_3, leftColumn, topRow);
    }

    /*
     * WARNING - void declaration
     */
    public final void createFreezePane(int sheetIndex, int colSplit, int rowSplit) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.createFreezePane((int)var1_1, (int)var2_2, (int)var3_3, -1, -1);
    }

    /*
     * WARNING - void declaration
     */
    public final void createFreezePane(String sheetName, int colSplit, int rowSplit) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.createFreezePane((String)var1_1, (int)var2_2, (int)var3_3, -1, -1);
    }

    /*
     * WARNING - void declaration
     */
    public final void createSplitPane(int sheetIndex, int xSplitPos, int ySplitPos, int leftColumn, int topRow) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.getSheet((int)var1_1).createSplitPane((int)var2_2, (int)var3_3, leftColumn, topRow, 0);
    }

    /*
     * WARNING - void declaration
     */
    public final void createSplitPane(String sheetName, int xSplitPos, int ySplitPos, int leftColumn, int topRow) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.createSplitPane(this.workbook.getSheetIndex((String)var1_1), (int)var2_2, (int)var3_3, leftColumn, topRow);
    }

    /*
     * WARNING - void declaration
     */
    public final void removePane(int sheetIndex) {
        void var1_1;
        this.createFreezePane((int)var1_1, 0, 0);
    }

    /*
     * WARNING - void declaration
     */
    public final void removePane(String sheetName) {
        void var1_1;
        this.createFreezePane((String)var1_1, 0, 0);
    }

    /*
     * WARNING - void declaration
     */
    public final void setSheetColor(int sheetIndex, int color) {
        if (this.workbook instanceof XSSFWorkbook) {
            void var2_2;
            void var1_1;
            ((XSSFSheet)this.workbook.getSheetAt((int)var1_1)).setTabColor((int)var2_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setSheetColor(String sheetName, int color) {
        if (this.workbook instanceof XSSFWorkbook) {
            void var2_2;
            void var1_1;
            ((XSSFSheet)this.workbook.getSheet((String)var1_1)).setTabColor((int)var2_2);
            return;
        }
        if (this.workbook instanceof HSSFWorkbook) {
            this.addWarning("Setting the sheet color for XLS files is not supported yet.");
        }
    }
}

