% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xObjSize.r
\name{xObjSize}
\alias{xObjSize}
\title{Function to estimate memory allocated for an R variable or a file}
\usage{
xObjSize(
obj,
type = c("auto", "variable", "file"),
units = "auto",
verbose = TRUE
)
}
\arguments{
\item{obj}{character specifying an R variable or a local file}

\item{type}{the object type specifying an R object or a local file. It
can be 'variable', 'file' or 'auto' (by default; automatically
determined)}

\item{units}{the units to be used in formatting the size. It can be
'auto', 'Kb', 'Mb', 'Gb', 'Tb', 'Pb'}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to TRUE for display}
}
\value{
If action is logical, a list containing arguments and their default
values. If action is NULL, a string specifying the assignment to be
evalated.
}
\description{
\code{xObjSize} is supposed to estimate memory allocated for an R
variable or a file.
}
\note{
This function is potentially useful when debugging as it frees
developers from specifying default values for all arguments except
those arguments of interest
}
\examples{
xObjSize(ls()[1])
#res <- lapply(ls(), xObjSize)
#res <- lapply(list.files(), xObjSize)
}
\seealso{
\code{\link{xObjSize}}
}
