% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xEnrichChord.r
\name{xEnrichChord}
\alias{xEnrichChord}
\title{Function to visualise enrichment results using a chord plot}
\usage{
xEnrichChord(eTerm, top_num = 5, FDR.cutoff = 0.05,
colormap.group = "ggplot2", colormap.ontology = NULL,
wrap.width = NULL, text.size = 0.6, legend = NULL, vline = F,
...)
}
\arguments{
\item{eTerm}{an object of class "eTerm" or "ls_eTerm". Alterntively, it
can be a data frame having all these columns (named as
'group','ontology','name','adjp','zscore')}

\item{top_num}{the number of the top terms (sorted according to adjp).
For the eTerm object, if it is 'auto' (for eTerm), only the significant
terms (see below FDR.cutoff) will be displayed}

\item{FDR.cutoff}{FDR cutoff used to declare the significant terms. By
default, it is set to 0.05}

\item{colormap.group}{short name for the group sector colormap}

\item{colormap.ontology}{short name for the ontology sector colormap}

\item{wrap.width}{a positive integer specifying wrap width of
labellings}

\item{text.size}{the text size of the labelings. By default, it is 0.6}

\item{legend}{logical to indicate whether to show the legend. If NULL,
automatically determined. For the group sector, the legends shown on
the bottom-left corner. For the ontology sector, the legends shown on
the bottom-right corner}

\item{vline}{logical to indicate whether to vertically put a line
seperating two symmetric parts of sectors}

\item{...}{additional graphic parameters (such as big.gap=15,
small.gap=1.5) used in circlize::chordDiagram}
}
\value{
a data frame used for visualisation
}
\description{
\code{xEnrichChord} is supposed to visualise enrichment results using a
chord plot. The thickness of links is proportional to the enrichment
Z-scores. Particularly useful for multiple groups and/or ontologies.
The left-half part sorted by the input groups (anti-clockwise), and the
right-half part sorted first by the input ontologies and then by the
number of links within an ontology (clockwise).
}
\note{
none
}
\examples{
\dontrun{
# Load the library
library(XGR)
RData.location <- "http://galahad.well.ox.ac.uk/bigdata/"

xEnrichChord(eTerm)
}
}
\seealso{
\code{\link{xEnrichChord}}
}
