% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xBigraph.r
\name{xBigraph}
\alias{xBigraph}
\title{Function to obtain communities from a bipartitle graph}
\usage{
xBigraph(g, algorithm = c("louvain", "leading_eigen", "fast_greedy",
"walktrap"), seed = 825, glayout = layout_with_kk,
edge.color.alternative = c("grey70", "grey95"), verbose = TRUE)
}
\arguments{
\item{g}{an object of class "igraph" (or "graphNEL") for a bipartitel
graph with a 'type' node attribute}

\item{algorithm}{the algorithm to initialise community from a projected
graph. It can be 'louvain' using multi-level optimization,
'leading_eigen' using leading eigenvector, 'fast_greedy' using greedy
optimization, and 'walktrap' via short random walks}

\item{seed}{an integer specifying the seed}

\item{glayout}{a graph layout function. This function can be one of
"layout_nicely" (previously "layout.auto"), "layout_randomly"
(previously "layout.random"), "layout_in_circle" (previously
"layout.circle"), "layout_on_sphere" (previously "layout.sphere"),
"layout_with_fr" (previously "layout.fruchterman.reingold"),
"layout_with_kk" (previously "layout.kamada.kawai"), "layout_as_tree"
(previously "layout.reingold.tilford"), "layout_with_lgl" (previously
"layout.lgl"), "layout_with_graphopt" (previously "layout.graphopt"),
"layout_with_sugiyama" (previously "layout.kamada.kawai"),
"layout_with_dh" (previously "layout.davidson.harel"),
"layout_with_drl" (previously "layout.drl"), "layout_with_gem"
(previously "layout.gem"), "layout_with_mds", and
"layout_as_bipartite". A full explanation of these layouts can be found
in \url{http://igraph.org/r/doc/layout_nicely.html}}

\item{edge.color.alternative}{two alternative colors for edges within
the community (grey70 by default) and edges between communities (grey95
by default)}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to true for display}
}
\value{
It returns an igraph object, appended by node attributes including
"community" for communit memberships, "contribution" for contribution
to its community, "xcoord" for x-coordinates, "ycoord" for
y-coordiates, and by edge attributes including "color" for
between-community edges ('grey95') and within-community edges
('grey70').
}
\description{
\code{xBigraph} is supposed to obtain communities from a bipartitle
graph.
}
\note{
The input graph will has an equal weight if there is no 'weight' edge
attribute associated with
}
\examples{
# 1) generate a random bipartite graph
set.seed(123)
g <- sample_bipartite(100, 50, p=0.1)
V(g)$name <- V(g)

\dontrun{
# 2) obtain its community
ig <- xBigraph(g)
gp <- xGGnetwork(ig, node.label='name', node.label.size=2,
node.label.color='black', node.label.alpha=0.8, node.label.padding=0,
node.label.arrow=0, node.label.force=0.002, node.shape='type',
node.shape.title='Type', node.xcoord='xcoord', node.ycoord='ycoord',
node.color='community', node.color.title='Community',
colormap='jet.both', ncolors=64, zlim=NULL, node.size='contribution',
node.size.range=c(1,4), node.size.title='Contribution', slim=NULL,
edge.color="color",edge.color.alpha=0.5,edge.curve=0,edge.arrow.gap=0)

## make it discrete for the colorbar
gp +
scale_colour_gradientn(colors=xColormap('jet.both')(64),breaks=seq(1,max(V(ig)$community)))
+ guides(color=guide_legend(title="Community"))
}
}
\seealso{
\code{\link{xGGnetwork}}
}
