% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xVisKernels.r
\name{xVisKernels}
\alias{xVisKernels}
\title{Function to visualise distance kernel functions}
\usage{
xVisKernels(exponent = 2, newpage = T)
}
\arguments{
\item{exponent}{an integer specifying decay exponent. By default, it
sets to 2}

\item{newpage}{logical to indicate whether to open a new page. By
default, it sets to true for opening a new page}
}
\value{
invisible
}
\description{
\code{xVisKernels} is supposed to visualise distance kernels, each of
which is a decaying function of: i) the relative distance \eqn{d_{gs}}
between the gene \eqn{g} and the SNP \eqn{s}, and ii) the decay
exponent \eqn{\lambda}.
}
\note{
There are five kernels that are currently supported:
\itemize{
\item{For "slow decay" kernel,
\eqn{h_{ds}(t)={1-{d_{gs}/D}\lambda}*(d_{gs} \le D)}}
\item{For "linear decay" kernel, \eqn{h_{ds}(t)={1-d_{gs}/D}*(d_{gs}
\le D)}}
\item{For "rapid decay" kernel,
\eqn{h_{ds}(t)={{1-d_{gs}/D}^\lambda}*(d_{gs} \le D)}}
}
}
\examples{
# visualise distance kernels
xVisKernels(exponent=2)
xVisKernels(exponent=3)
}
\seealso{
\code{\link{xSNP2nGenes}}
}

