% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotly_duane.R
\name{plotly_duane}
\alias{plotly_duane}
\title{Interactive Duane Plot.}
\usage{
plotly_duane(
  duane_obj,
  showGrid = TRUE,
  main = "Duane Plot",
  xlab = "Cumulative Time",
  ylab = "Cumulative MTBF",
  pointCol = "black",
  fitCol = "black",
  gridCol = "lightgray"
)
}
\arguments{
\item{duane_obj}{An object of class 'duane'.}

\item{showGrid}{Show grid (TRUE) or hide grid (FALSE).}

\item{main}{Main title.}

\item{xlab}{X-axis label.}

\item{ylab}{Y-axis label.}

\item{pointCol}{Color of the point values.}

\item{fitCol}{Color of the model fit.}

\item{gridCol}{Color of the grid.}
}
\value{
The function returns no value.
}
\description{
This function creates an interactive Duane plot for a duane object.
}
\examples{
library(ReliaGrowR)
times<-c(100, 200, 300, 400, 500)
failures<-c(1, 2, 1, 3, 2)
fit<-duane_plot(times, failures)
plotly_duane(fit)
}
